# Claw Permission Firewall

Runtime least-privilege firewall for agent/skill actions. It evaluates a requested action and returns one of:

- **ALLOW** (safe to execute)
- **DENY** (blocked by policy)
- **NEED_CONFIRMATION** (risky; require explicit confirmation)

It also returns a **sanitizedAction** with secrets redacted, plus a structured **audit** record.

> This is not a gateway hardening tool. It complements gateway security scanners by enforcing per-action policy at runtime.

---

## What it protects against
- Exfiltration to unknown domains
- Prompt-injection “send secrets” attempts (secret detection + redaction)
- Reading sensitive local files (`~/.ssh`, `~/.aws`, `.env`, etc.)
- Unsafe execution patterns (`rm -rf`, `curl | sh`, etc.)

---

## Inputs
Provide an action object to evaluate:

```json
{
  "traceId": "optional-uuid",
  "caller": { "skillName": "SomeSkill", "skillVersion": "1.2.0" },
  "action": {
    "type": "http_request | file_read | file_write | exec",
    "method": "GET|POST|PUT|DELETE",
    "url": "https://api.github.com/...",
    "headers": { "authorization": "Bearer ..." },
    "body": "...",
    "path": "./reports/out.json",
    "command": "rm -rf /"
  },
  "context": {
    "workspaceRoot": "/workspace",
    "mode": "strict | balanced | permissive",
    "confirmed": false
  }
}
```

---

## Outputs
```json
{
  "decision": "ALLOW | DENY | NEED_CONFIRMATION",
  "riskScore": 0.42,
  "reasons": [{"ruleId":"...","message":"..."}],
  "sanitizedAction": { "...": "..." },
  "confirmation": { "required": true, "prompt": "..." },
  "audit": { "traceId":"...", "policyVersion":"...", "actionFingerprint":"..." }
}
```

---

## Default policy behavior (v1)
- **Exec disabled** by default
- HTTP requires **TLS**
- Denylist blocks common exfil hosts (pastebins, raw script hosts)
- File access is jailed to **workspaceRoot**
- Always redacts `Authorization`, `Cookie`, `X-API-Key`, and common token patterns

---

## Recommended usage pattern
1) Your skill creates an action object.
2) Call this skill to evaluate it.
3) If **ALLOW** → execute sanitizedAction.
4) If **NEED_CONFIRMATION** → ask user and re-run with `context.confirmed=true`.
5) If **DENY** → stop and show the reasons.

---

## Files
- `policy.yaml` contains the policy (edit for your environment).
