# 贡献指南

感谢你对 Claw Memory Guardian 的兴趣！我们欢迎各种形式的贡献。

## 🎯 贡献方式

### 1. 报告问题
- 使用 [GitHub Issues](https://github.com/openclaw-skills/claw-memory-guardian/issues) 报告bug
- 描述清晰的问题现象和复现步骤
- 包括你的环境信息（OpenClaw版本、操作系统等）

### 2. 功能建议
- 在 Issues 中提出功能建议
- 描述使用场景和预期效果
- 如果有实现思路，欢迎一起讨论

### 3. 代码贡献
- Fork 仓库并创建功能分支
- 遵循代码规范
- 添加测试用例
- 提交 Pull Request

### 4. 文档改进
- 修复文档错误
- 添加使用示例
- 翻译文档

### 5. 社区帮助
- 回答其他用户的问题
- 分享使用经验
- 推广项目

## 🛠️ 开发环境设置

### 前提条件
- Node.js >= 14.0.0
- npm 或 yarn
- Git

### 步骤
```bash
# 1. 克隆仓库
git clone https://github.com/openclaw-skills/claw-memory-guardian.git
cd claw-memory-guardian

# 2. 安装依赖
npm install

# 3. 运行测试
npm test

# 4. 开发模式
npm run dev  # 如果有的话
```

## 📁 项目结构

```
claw-memory-guardian/
├── SKILL.md              # 主技能文档
├── README.md            # 项目README
├── package.json         # 项目配置
├── index.js             # 主入口文件
├── install.js           # 安装脚本
├── uninstall.js         # 卸载脚本
├── test.js              # 测试文件
├── EXAMPLES.md          # 使用示例
├── CONTRIBUTING.md      # 贡献指南（本文件）
├── LICENSE              # 许可证
└── docs/                # 文档目录（未来）
```

## 📝 代码规范

### JavaScript 规范
- 使用 ES6+ 语法
- 使用 async/await 处理异步
- 添加必要的错误处理
- 代码注释使用英文

### 文件命名
- 使用小写字母和连字符
- 描述性文件名
- 统一扩展名

### 提交信息
使用约定式提交：
- `feat:` 新功能
- `fix:` bug修复
- `docs:` 文档更新
- `style:` 代码格式
- `refactor:` 代码重构
- `test:` 测试相关
- `chore:` 构建过程或辅助工具

示例：
```
feat: 添加语义搜索功能
fix: 修复备份文件损坏问题
docs: 更新安装说明
```

## 🧪 测试要求

### 测试覆盖
- 核心功能必须有测试
- 边界条件需要测试
- 错误处理需要测试

### 运行测试
```bash
# 运行所有测试
npm test

# 运行特定测试
node test.js
```

### 测试标准
- 测试通过率 >= 90%
- 新功能必须有测试
- 修复bug时添加回归测试

## 🔄 开发流程

### 1. 创建分支
```bash
git checkout -b feat/your-feature-name
```

### 2. 开发功能
- 编写代码
- 添加测试
- 更新文档

### 3. 提交代码
```bash
git add .
git commit -m "feat: 描述你的功能"
```

### 4. 推送分支
```bash
git push origin feat/your-feature-name
```

### 5. 创建 Pull Request
- 在 GitHub 创建 PR
- 描述更改内容
- 关联相关 Issue

### 6. 代码审查
- 等待维护者审查
- 根据反馈修改
- 通过后合并

## 🎨 设计原则

### 核心原则
1. **实用性** - 解决真实问题
2. **易用性** - 简单直观的接口
3. **可靠性** - 稳定可靠的运行
4. **可扩展性** - 方便未来扩展

### 用户体验
- 清晰的错误信息
- 友好的命令行界面
- 详细的文档
- 渐进式功能展示

### 性能考虑
- 内存使用优化
- 文件操作效率
- 搜索性能
- 备份速度

## 📚 文档要求

### 技能文档 (SKILL.md)
- 完整的功能描述
- 安装和使用说明
- 配置选项说明
- 使用场景示例

### API 文档
- 函数和方法的说明
- 参数和返回值
- 使用示例
- 注意事项

### 示例文档
- 实际使用场景
- 最佳实践
- 故障排除

## 🐛 问题处理流程

### 1. 确认问题
- 复现问题
- 确认环境
- 收集日志

### 2. 分析原因
- 查看相关代码
- 分析错误信息
- 确定根本原因

### 3. 制定方案
- 设计修复方案
- 评估影响范围
- 编写测试用例

### 4. 实施修复
- 编写修复代码
- 运行测试
- 更新文档

### 5. 验证修复
- 手动测试
- 自动化测试
- 用户验证

## 🤝 沟通协作

### 沟通渠道
- GitHub Issues - 问题讨论
- GitHub Discussions - 功能讨论
- Pull Requests - 代码审查

### 沟通准则
- 尊重他人意见
- 提供建设性反馈
- 保持专业态度
- 使用清晰的语言

## 📅 发布流程

### 版本号规则
使用语义化版本：
- `MAJOR` - 不兼容的API修改
- `MINOR` - 向下兼容的功能新增
- `PATCH` - 向下兼容的问题修复

### 发布步骤
1. 更新版本号
2. 更新变更日志
3. 运行完整测试
4. 创建发布标签
5. 发布到 ClawdHub
6. 更新文档

## 🙏 致谢

感谢所有贡献者的付出！你的每一份贡献都让这个项目变得更好。

### 贡献者名单
（按贡献时间排序）

---

**让我们一起打造更好的记忆守护者！** 🧠