# Email Templates Reference

The email composer includes three built-in templates optimized for Apple Mail,
Gmail, Outlook, and other major email clients. All use inline CSS for compatibility.

---

## default

Full-featured template with header banner, body, optional CTA button, and footer.

### Template Variables

| Variable | Description |
|----------|-------------|
| `subject` | Email subject (used in `<title>` and fallback header) |
| `body` | Main content (HTML allowed) |
| `greeting` | Greeting line above body (e.g., "Hi team,") |
| `sign_off` | Sign-off below body (e.g., "Best regards") |
| `header_text` | Header banner text (defaults to subject) |
| `header_color` | Header background color (default: `#2d3748`) |
| `footer_text` | Footer text (centered, small) |
| `action_url` | CTA button URL |
| `action_text` | CTA button label (default: "View Details") |
| `action_color` | CTA button color (default: `#4299e1`) |

### Visual Structure

```
┌──────────────────────────────────┐
│  HEADER (header_color bg)        │
│  header_text                     │
├──────────────────────────────────┤
│  greeting                        │
│                                  │
│  body                            │
│                                  │
│  [action_text] (button)          │
│                                  │
│  sign_off                        │
├──────────────────────────────────┤
│  footer_text (small, centered)   │
└──────────────────────────────────┘
```

### Example

```bash
python3 scripts/send_mail.py \
  --to "user@example.com" \
  --subject "Your Weekly Summary" \
  --body "<p>Here are your metrics for the week.</p><ul><li>Tasks: 42</li><li>PRs: 7</li></ul>" \
  --template default \
  --greeting "Hi Sarah," \
  --sign-off "— The OpenClaw Team" \
  --header-text "Weekly Summary" \
  --header-color "#2b6cb0" \
  --footer-text "You're receiving this because you enabled weekly summaries." \
  --action-url "https://dashboard.example.com" \
  --action-text "View Dashboard" \
  --action-color "#48bb78"
```

---

## minimal

Clean, lightweight template for simple messages. No wrapper table, no header/footer.

### Template Variables

| Variable | Description |
|----------|-------------|
| `subject` | Email subject |
| `body` | Main content |
| `sign_off` | Optional sign-off |

### Visual Structure

```
body text

sign_off
```

### Example

```bash
python3 scripts/send_mail.py \
  --to "colleague@example.com" \
  --subject "Quick question" \
  --body "Can you review the PR when you get a chance?" \
  --template minimal \
  --sign-off "Thanks!"
```

---

## digest

Tabular report template for data-driven emails (reports, summaries, digests).

### Template Variables

| Variable | Description |
|----------|-------------|
| `subject` | Email subject |
| `header_text` | Header banner text |
| `header_color` | Header color (default: `#2d3748`) |
| `summary` | Summary text above the table |
| `items` | JSON array of row dictionaries |
| `columns` | JSON array of column header strings |
| `footer_text` | Footer text |

### Visual Structure

```
┌──────────────────────────────────┐
│  HEADER                          │
├──────────────────────────────────┤
│  summary text                    │
│                                  │
│  ┌──────┬──────┬──────┐          │
│  │ Col1 │ Col2 │ Col3 │          │
│  ├──────┼──────┼──────┤          │
│  │ val  │ val  │ val  │          │
│  │ val  │ val  │ val  │          │
│  └──────┴──────┴──────┘          │
├──────────────────────────────────┤
│  footer_text                     │
└──────────────────────────────────┘
```

### Example

```bash
python3 scripts/compose_mail.py \
  --to "team@example.com" \
  --subject "Sprint Review" \
  --template digest \
  --header-text "Sprint 42 Results" \
  --header-color "#2d3748" \
  --summary "Here are the final metrics for Sprint 42." \
  --items '[{"Task":"Auth flow","Status":"Done","Owner":"Alice"},{"Task":"Search","Status":"In Progress","Owner":"Bob"}]' \
  --columns '["Task","Status","Owner"]' \
  --footer-text "Generated by OpenClaw" \
  | python3 scripts/send_mail.py --from-stdin --transport smtp \
    --smtp-host smtp.gmail.com --smtp-user me@gmail.com --smtp-pass "pass"
```

---

## Custom Templates

Place custom Jinja2 or `$variable` templates in the `assets/` directory. Reference
them by filename: `--template my-template.html`.

Templates should use inline CSS for email client compatibility. Use `${}` variables
(Python string.Template syntax) for dynamic content.
