# Claw Desktop Pet

> 🦞 企业级7×24稳定运行的桌面龙虾智能助手

一个可爱又强大的桌面AI助手，具备企业级的稳定性和智能语音交互能力。

## 🌟 主要特性

### 🛡️ 系统级容错
- 5种错误全捕获：未捕获异常、Promise拒绝、渲染进程崩溃、子进程错误、主进程错误
- 智能自愈机制
- 完整错误日志记录

### 🔄 自动重启
- 崩溃后自动恢复
- 真正7×24运行
- 重启计数和统计

### 📊 性能监控
- 实时健康评分
- CPU和内存监控
- 异常告警
- 性能指标记录

### 🎙️ 智能语音
- 口语化自然播报
- 情境化表达
- 优先级管理
- Edge TTS支持

### 📝 日志管理
- 自动轮转
- 大小限制
- 完整可观测
- 结构化日志

### 🧹 资源优化
- 自动清理缓存
- 日志文件管理
- 内存优化

## 🚀 快速开始

### 安装

```bash
# 克隆项目
git clone https://github.com/kk43994/claw-desktop-pet.git
cd claw-desktop-pet

# 安装依赖
npm install
pip install edge-tts

# 启动
npm start
```

### 配置

编辑 `desktop-bridge.js` 配置OpenClaw集成:

```javascript
const OPENCLAW_PORT = 18788;
const VOICE_ENABLED = true;
```

## 💡 使用场景

- 需要24小时稳定运行的桌面助手
- OpenClaw用户寻找桌面客户端  
- 想要可视化AI交互界面
- 需要语音播报功能的开发者
- 喜欢桌面宠物的用户

## 📚 文档

- [README](https://github.com/kk43994/claw-desktop-pet#readme) - 项目说明
- [RELEASE-v1.3.0.md](https://github.com/kk43994/claw-desktop-pet/blob/master/RELEASE-v1.3.0.md) - 发布说明
- [技术文档](https://github.com/kk43994/claw-desktop-pet/tree/master/docs) - 6份详细文档

## 🔧 技术栈

- **前端:** Electron
- **后端:** OpenClaw + Node.js
- **语音:** Edge TTS + Python
- **平台:** Windows 10/11

## 📊 项目统计

- **版本:** v1.3.0
- **代码:** ~6000行
- **文档:** 6份技术文档
- **测试:** 5个测试脚本
- **许可证:** MIT

## 🤝 贡献

欢迎提Issue和PR!

## 📄 许可证

MIT © kk43994

---

Made with ❤️ and 🦞
