---
name: claw-backup
version: 1.0.15
description: Back up OpenClaw customizations (memory, config, skills, workspace) to cloud storage via rclone, with scheduling + retention. Works on macOS, Linux, and Windows (Git Bash/WSL).
---

# Claw Backup
Version: 1.0.15

**OpenClaw backup skill** — schedules backups of your OpenClaw data (memory, config, skills, workspace) to an `rclone` destination (e.g. Google Drive). Works on macOS, Linux, and Windows (via Git Bash or WSL).

## What it does

- Backs up **clawd memory**, **~/.openclaw** (config, skills, modules, workspace, cron), **clawd/scripts**, and **Dev/CursorApps/clawd** (excluding `node_modules`)
- Runs on a schedule (macOS LaunchAgent, Linux cron, or Windows Task Scheduler)
- Applies local and remote retention so old backups are pruned
- Supports `rclone` (cloud) or `local-only` upload mode

## Before you install

- **Do not** run `curl ... | node` (or any one-liner) without first inspecting the script. Prefer **git clone** and open `setup.js` and `install-launchagent.sh` (or the cron/Task Scheduler scripts) to review what they will do.
- **Verify the code** in `setup.js` and the scheduler installer: confirm only the expected paths are archived and that there is no unexpected network use or commands. If you are uncomfortable reviewing the scripts, do not install.
- **Confirm repository identity**: official source is [github.com/vidarbrekke/ClawBackup](https://github.com/vidarbrekke/ClawBackup). The version in this SKILL.md (frontmatter and "Version" line) is the source of truth; the registry may show a different revision number.
- **Use encryption** for sensitive backups: an encrypted rclone remote (e.g. `rclone crypt`) or encrypt archives yourself before offsite storage.
- **After installation**: inspect your LaunchAgent plist, crontab, or Task Scheduler entries, and run a **test backup to a local destination first** before using a cloud remote.

## Restore notes

Each archive includes `RESTORE_NOTES.txt` with the correct restore targets based
on the configured paths. In general:

- `openclaw_config/skills` → `~/.openclaw/skills`
- `cursorapps_clawd/skills` → `~/Dev/CursorApps/clawd/skills` (or your chosen path)

## Quick start

1. **Prerequisites:** Node.js, [rclone](https://rclone.org/install/) configured for Google Drive, and Bash (or Git Bash on Windows).
   - `rclone` is only required when upload mode is `rclone`.

2. **Recommended install (review first):**
   ```bash
   git clone https://github.com/vidarbrekke/ClawBackup.git
   cd ClawBackup
   node setup.js
   ```

3. **Quick install (not recommended):** Only use if you have already inspected the script. Do **not** run without review:
   ```bash
   curl -fsSL https://raw.githubusercontent.com/vidarbrekke/ClawBackup/main/setup.js | node
   ```
4. Follow the prompts (or use `node setup.js --defaults` for default paths). Then run the printed test command and install the scheduler as shown.

## Security notes

- Backups may contain sensitive data (OpenClaw config, memory, and skills).
- Setup can install recurring scheduler entries (LaunchAgent/cron/Task Scheduler); inspect these after install.
- In cloud mode, credentials come from your existing `rclone config`; no extra env vars are required by this repo.
- Prefer encrypted destinations (e.g. `rclone crypt`) or encrypt archives before offsite storage.
- Archives include checksum files (`.sha256`) for integrity checks.

## Repo and contributions

- **Code and full docs:** [github.com/vidarbrekke/ClawBackup](https://github.com/vidarbrekke/ClawBackup)
- **Improvements welcome:** Open issues or pull requests on the GitHub repo. The project is open for refinements, fixes, and features from any OpenClaw user.

## License

MIT
