---
name: claw-admin
description: "Provision and manage @clawemail.com Google Workspace email accounts. Use when the user wants to create an email for their AI agent, check email availability, or manage existing ClawEmail accounts."
user-invocable: true
metadata: {"openclaw":{"requires":{"env":["CLAWEMAIL_API_KEY"]},"primaryEnv":"CLAWEMAIL_API_KEY","emoji":"🦞"}}
---

# ClawEmail

Provision and manage **@clawemail.com** Google Workspace email accounts for AI agents. Each account comes with full Gmail, Docs, Sheets, Calendar, and Drive access plus OAuth credentials for programmatic use.

## Setup

Set your API key as an environment variable:

```
export CLAWEMAIL_API_KEY=your_api_key_here
```

**Base URL:** `https://clawemail.com`

All admin endpoints require the header: `-H "X-API-Key: $CLAWEMAIL_API_KEY"`

## Check Email Availability (Public — no API key needed)

Before creating an account, always check if the prefix is available:

```bash
curl -s https://clawemail.com/check/DESIRED_PREFIX
```

Response when available:
```json
{"prefix":"tom","email":"tom@clawemail.com","available":true}
```

Response when taken or reserved:
```json
{"available":false,"errors":["This email is reserved"]}
```

## Create Email Account

Provisions a new @clawemail.com Google Workspace user. Returns a temporary password and an OAuth connect URL.

```bash
curl -s -X POST https://clawemail.com/api/emails \
  -H "X-API-Key: $CLAWEMAIL_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"prefix":"DESIRED_PREFIX"}'
```

Response:
```json
{
  "success": true,
  "email": "tom@clawemail.com",
  "password": "aB3$xYz...",
  "connect_url": "https://clawemail.com/connect/tom",
  "instructions": "1. User logs into Gmail with the email/password above. 2. User visits connect_url to authorize OAuth. 3. User receives their OpenClaw credentials."
}
```

**Important:** Save the password immediately — it is shown only once.

After creation, the user must:
1. Log in to Gmail at https://mail.google.com with the new email and password
2. Visit the `connect_url` to authorize OAuth and receive their credentials JSON

## List All Emails

```bash
curl -s https://clawemail.com/api/emails \
  -H "X-API-Key: $CLAWEMAIL_API_KEY"
```

Supports pagination with `?limit=100&offset=0`.

## Get Email Details

```bash
curl -s https://clawemail.com/api/emails/PREFIX \
  -H "X-API-Key: $CLAWEMAIL_API_KEY"
```

Returns email status, creation date, OAuth connection date, and Workspace user details.

## Suspend Email

Temporarily disables a Google Workspace account (preserves data):

```bash
curl -s -X POST https://clawemail.com/api/emails/PREFIX/suspend \
  -H "X-API-Key: $CLAWEMAIL_API_KEY"
```

## Unsuspend Email

Re-enables a previously suspended account:

```bash
curl -s -X POST https://clawemail.com/api/emails/PREFIX/unsuspend \
  -H "X-API-Key: $CLAWEMAIL_API_KEY"
```

## Delete Email

Permanently deletes the Google Workspace account and all associated data:

```bash
curl -s -X DELETE https://clawemail.com/api/emails/PREFIX \
  -H "X-API-Key: $CLAWEMAIL_API_KEY"
```

## Self-Service Signup (No API Key)

For users who want to sign up themselves through Stripe checkout:

1. Direct them to: `https://clawemail.com/signup?prefix=DESIRED_PREFIX`
2. They choose monthly ($16/mo) or annual ($160/yr), enter billing email, and pay via Stripe
3. After payment they receive their password and OAuth connect link

## Typical Workflow

1. **Check availability:** `curl -s https://clawemail.com/check/myagent`
2. **Create account:** POST to `/api/emails` with the prefix
3. **Save credentials:** Store the password securely
4. **Connect OAuth:** Direct user to the `connect_url` from the response
5. **Use the account:** The agent now has a real Gmail address with full Google Workspace access

## Prefix Rules

- Must be 3-30 characters
- Must start with a letter
- Can contain letters, numbers, dots, underscores, or hyphens
- Many common names, brands, and words are reserved

## When to Use

- User asks to create an email account for their AI agent
- User needs a Google Workspace account with OAuth access
- User wants to check if a specific email address is available
- User needs to manage (suspend/unsuspend/delete) an existing account
