# Escalation Rules

Guidelines for when the supervisor should act autonomously vs involve a human.

## Autonomy Levels

### Level 1: Auto-handle (no human needed)
- Transient API 500 errors → nudge "continue"
- Agent stopped mid-task with no errors → nudge "continue with the task"
- Simple permission prompts for file writes in project directory → approve
- Agent completed task, tests pass → report done

### Level 2: Auto-handle with report
- Agent completed task but with warnings → report with summary
- Rate limiting (429) → wait and retry, report if persists >10 min
- Agent made multiple attempts at same fix → report progress

### Level 3: Escalate to human
- nudgeCount exceeds maxNudges (default: 5)
- Same error repeated after nudging
- Agent wants to run destructive commands (rm, drop, force push)
- Agent requests credentials or secrets
- Task duration exceeds escalateAfterMin
- Agent is clearly off-track (working on wrong thing)
- tmux session died unexpectedly
- Unknown or ambiguous state

## Quiet Hours

Between 23:00 and 08:00 (human's timezone):
- Level 1: Still auto-handle
- Level 2: Queue report for morning
- Level 3: Only escalate if truly urgent (data loss risk, security)

## Escalation Format

Keep it brief and actionable:

```
👷 Supervisor Alert: [session-name]

Goal: [original goal]
Status: [stuck/error/needs-decision]
Nudges: [count]/[max]
Duration: [time since start]

Last output:
[5-10 relevant lines from tmux]

Needs: [what you need from the human]
```
