#!/bin/bash
# 07-weekly-improvement-cron.sh
# Weekly research and improvement suggestions for Claude Code workflow
# Designed to be run by Clawdbot cron job

# This script outputs a report that should be reviewed by a human before applying changes

set -e

SCRIPT_DIR="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)"
SKILL_DIR="$(dirname "$SCRIPT_DIR")"
OUTPUT_DIR="$SKILL_DIR/improvements"
DATE=$(date +%Y-%m-%d)
REPORT_FILE="$OUTPUT_DIR/report-$DATE.md"

mkdir -p "$OUTPUT_DIR"

cat > "$REPORT_FILE" << 'HEADER'
# Claude Code Weekly Improvement Report

Generated: DATE_PLACEHOLDER

This report contains research and suggestions for improving our Claude Code workflow.
**Review all suggestions before applying any changes.**

---

HEADER

sed -i '' "s/DATE_PLACEHOLDER/$(date)/" "$REPORT_FILE" 2>/dev/null || \
sed -i "s/DATE_PLACEHOLDER/$(date)/" "$REPORT_FILE"

# Section 1: Latest Documentation Changes
cat >> "$REPORT_FILE" << 'SECTION1'
## 1. Claude Code Documentation Updates

**Action Required:** Agent should check https://code.claude.com/docs for:
- New features announced
- Changed commands or APIs
- New best practices
- Deprecation notices

### Research Tasks:
- [ ] Check release notes / changelog
- [ ] Review subagents documentation for changes
- [ ] Check for new CLI flags or commands
- [ ] Look for new built-in agents

### Findings:
<!-- Agent fills this in -->

---

SECTION1

# Section 2: Community Insights
cat >> "$REPORT_FILE" << 'SECTION2'
## 2. Community Usage Patterns

**Action Required:** Agent should search for:
- X/Twitter: "claude code" tips, workflows, complaints
- Reddit: r/ClaudeAI for Claude Code discussions
- GitHub: Issues/discussions in anthropics repos
- YouTube: Recent Claude Code tutorials

### Research Tasks:
- [ ] Search X for "claude code" (last 7 days)
- [ ] Check r/ClaudeAI for popular Claude Code posts
- [ ] Look for common pain points users mention
- [ ] Find creative workflows others are using

### Findings:
<!-- Agent fills this in -->

---

SECTION2

# Section 3: Our Usage Patterns
cat >> "$REPORT_FILE" << 'SECTION3'
## 3. Our Own Usage Analysis

**Action Required:** Agent should review:
- Recent memory entries about Claude Code usage
- Common tasks we use Claude Code for
- Pain points we've encountered
- Workarounds we've discovered

### Research Tasks:
- [ ] Search memory for "claude code" entries
- [ ] Review recent coding sessions
- [ ] Identify repeated patterns
- [ ] Note any frustrations or workarounds

### Findings:
<!-- Agent fills this in -->

---

SECTION3

# Section 4: Suggested Improvements
cat >> "$REPORT_FILE" << 'SECTION4'
## 4. Suggested Improvements

Based on research, here are potential improvements:

### Subagent Updates
<!-- List any suggested changes to existing subagents -->

### New Subagents
<!-- Suggest new subagents based on needs -->

### Configuration Changes
<!-- Suggest settings.json or CLAUDE.md updates -->

### Workflow Changes
<!-- Suggest process improvements -->

### Skill Documentation Updates
<!-- Suggest SKILL.md updates -->

---

## 5. Action Items

**⚠️ REQUIRES HUMAN APPROVAL**

The following changes are suggested. Apply only after review:

| Change | File | Approved? |
|--------|------|-----------|
| <!-- Change 1 --> | <!-- File --> | [ ] |
| <!-- Change 2 --> | <!-- File --> | [ ] |

---

## How to Apply

After reviewing and approving changes:

1. For subagent updates:
   ```bash
   # Edit the agent file
   vim ~/.claude/agents/[agent-name].md
   ```

2. For new subagents:
   ```bash
   # Create new agent file
   vim ~/.claude/agents/[new-agent].md
   ```

3. For config changes:
   ```bash
   # Edit settings
   vim ~/.claude/settings.json
   ```

---

*Report generated by claude-code-mastery skill*
*Review before applying any changes*
SECTION4

echo "📋 Report generated: $REPORT_FILE"
echo ""
echo "This report template has been created."
echo "The Clawdbot agent should now:"
echo "1. Research the items in each section"
echo "2. Fill in the findings"
echo "3. Propose specific improvements"
echo "4. Wait for human approval before applying"
