---
name: clash-node-manager
description: Manages Clash proxy nodes. Allows listing current node with connection status, listing available nodes, and switching to a specified node. Use when the user asks to manage Clash proxy settings, view available nodes, or switch between them.
---

# Clash Node Manager

## Overview

This skill enables you to manage your Clash proxy nodes using `check_clash.py`. You can list available nodes, check the connection status of the current node, and switch to a different node.

## Usage

### Checking Node Status (Default)

To check the status of Clash nodes, ask:

"Check Clash node status"

This will execute `python check_clash.py`.

### Listing Available Nodes

To list available nodes in the GLOBAL group, ask:

"List available Clash nodes"

This will execute `python check_clash.py --list`

To list available nodes in a specific group, ask:

"List available nodes in group <group_name>"

Replace `<group_name>` with the name of the group.  This will execute `python check_clash.py --group <group_name> --list`

### Switching to a Node

To switch to a specific node, ask:

"Switch to node <node_name>"

Replace `<node_name>` with the name of the node you want to switch to. This will execute `python check_clash.py --switch <node_name>`.

### Switching to a Node by Index

To switch to a node by its index in the list, ask:

"Switch to node at index <index>"

Replace `<index>` with the index of the node in the list.  This will execute `python check_clash.py --switch-by-index <index>`.

### Resources

*   `check_clash.py`: Python script for checking and switching Clash proxy nodes.
