<!--
TREND ANALYSIS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See trend-analysis/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Confidence: HIGH / MEDIUM / LOW
- Cycle Phase: Accumulation / Early bull / Mid bull / Late bull / Distribution / Bear
- Trend Maturity: Embryonic / Growth / Mature
- Tier: Tier 1 (Act now) / Tier 2 (Watch) / Tier 3 (Already priced in) / Tier 4 (Avoid)
- Momentum: Accelerating / Stable / Decelerating
- Validation: Fundamental / Speculative / Mixed
-->

# Trend Analysis - {Time Horizon}

**Topic:** Crypto market trend analysis for {time horizon}
**Time horizon:** {6 months | 1 year | 2-5 years | this cycle | next cycle}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick investment decision-making
> **Detail level:** concise
> **Format:** Market context, Top 3 predictions (with confidence and timeframe), Immediate opportunities (Tier 1/2), Key risks

---

## 1. MARKET CONTEXT & TREND LANDSCAPE

> **Purpose:** Establish market cycle context and inventory of active trends
> **Questions:** What cycle phase? | What trends are currently active? | How do they classify by maturity/momentum?
> **Detail level:** standard

### 1.1 Market Cycle Assessment

> **What to deliver:** Current cycle phase with evidence, key characteristics (market behavior, sentiment, liquidity), implications for trend analysis
> **Format:** Phase identification with evidence, characteristics assessment, implications

### 1.2 Current Trend Inventory

> **What to deliver:** Comprehensive inventory of active trends across relevant categories
> **Format:** Categorized lists (AI determines categories based on current market: Sector, Narrative, Technology, Business Model, etc.)
> **Note:** Typically 10-20 active trends

### 1.3 Trend Classification

> **What to deliver:** Classification of trends by maturity (Embryonic/Growth/Mature) and momentum
> **Format:** Table or structured assessment

---

## 2. TREND STRENGTH ASSESSMENT

> **Purpose:** Deep analysis of major trends using multi-source validation
> **Questions:** Which trends have real fundamental backing? | Which are pure speculation? | Signal convergence?
> **Detail level:** detailed

### 2.1 Major Trend Analysis

> **What to deliver:** Multi-source validated assessment of 5-10 major trends (social signals, on-chain data, development activity, capital flows, convergence)
> **Format:** Per trend: overview, signal analysis across sources, convergence assessment (fundamental vs speculative)
> **Note:** AI determines depth per trend based on significance

### 2.2 Trend Strength Rankings

> **What to deliver:** Ranked comparison of analyzed trends by strength
> **Format:** Ranking table with confidence, momentum, validation status

---

## 3. EMERGING TREND PREDICTIONS

> **Purpose:** Predict emerging trends with high growth potential for specified time horizon
> **Questions:** What trends will emerge/accelerate? | What's the evidence? | Catalysts and timing?
> **Detail level:** detailed

### 3.1 Methodology

> **What to deliver:** Prediction approach tailored to user's timeframe
> **Format:** Brief methodology description
> **Note:** Short-term = narrative-driven; Medium-term = adoption curves; Long-term = paradigm shifts

### 3.2 Top Emerging Trend Predictions

> **What to deliver:** 5-8 emerging trend predictions ranked by conviction with growth thesis, current signals, catalysts timeline, confidence level, risk factors, invalidation triggers
> **Format:** Structured prediction entries. Top 3 should be highest conviction
> **Note:** Include specific catalysts with timing

### 3.3 Prediction Summary

> **What to deliver:** Consolidated view of all predictions
> **Format:** Summary table with key attributes

---

## 4. INVESTMENT OPPORTUNITIES

> **Purpose:** Translate trend predictions into actionable investment framework
> **Questions:** Which trends offer best risk/reward? | Specific opportunities? | Entry timing?
> **Detail level:** detailed

### 4.1 Opportunity Tiers

> **What to deliver:** Categorize trends/opportunities by investment timing (Tier 1-4)
> **Format:** Tier 1 (Early Positioning), Tier 2 (Watch for Entry), Tier 3 (Already Priced In), Tier 4 (Avoid) with trends, characteristics, recommended action

### 4.2 Specific Opportunities

> **What to deliver:** For Tier 1-2 trends: leading projects, entry considerations, position sizing guidance, risk management
> **Format:** Per trend: specific opportunities with actionable details
> **Note:** Focus on executable recommendations

### 4.3 Investment Watchlist

> **What to deliver:** Consolidated watchlist for tracking
> **Format:** Table with project, trend, entry trigger, risk level

---

## 5. RISK MONITORING FRAMEWORK

> **Purpose:** Framework for monitoring predictions and knowing when to exit
> **Questions:** What signals indicate thesis is working? | What signals indicate exit? | Scenario analysis?
> **Detail level:** standard

### 5.1 Invalidation Signals

> **What to deliver:** Clear signals that would invalidate trend predictions (social, on-chain, development, capital)
> **Format:** By category with specific thresholds where possible

### 5.2 Scenario Analysis

> **What to deliver:** Bull/Base/Bear case outcomes with probability and assumptions
> **Format:** Three scenarios with probability %, assumptions, expected outcomes

### 5.3 Monitoring Checklist

> **What to deliver:** Actionable monitoring framework (weekly/monthly/quarterly) and exit triggers
> **Format:** Frequency-based checklist, clear exit conditions

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-5

---

## SOURCES & REFERENCES

### Primary Sources
{Blockchain explorers, protocol docs, GitHub, on-chain data}

### Secondary Sources
{Data platforms, research reports, news}

### Tertiary Sources
{Social media, community discussions}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
