# TREND ANALYSIS & PREDICTION

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Trend Analysis & Prediction (trend-analysis)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Establish comprehensive trend intelligence covering current market landscape, strength assessment, and emerging trend predictions for user-specified time horizon. Delivers confidence-scored predictions with actionable investment implications, risk monitoring framework, and clear validation criteria. Enables users to position early in emerging trends and capitalize on market shifts before mainstream adoption through evidence-based, multi-source validated analysis.

---

## OBJECTIVES

1. **Market Context & Trend Landscape** - Establish market cycle context and comprehensive inventory of active trends with classification by maturity and momentum

2. **Trend Strength Assessment** - Multi-source validation of major trends to distinguish fundamental trends from speculation. Apply research-methodology.md

3. **Emerging Trend Predictions** - Forecast emerging trends for specified time horizon with confidence scoring, catalysts timeline, and invalidation triggers

4. **Investment Opportunities** - Translate predictions into tiered actionable opportunities with specific entry guidance and watchlist

5. **Risk Monitoring Framework** - Establish invalidation signals, scenario analysis, and monitoring checklist for capital protection

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

**CRITICAL REQUIREMENT - Time Horizon:**
User MUST specify target time horizon for predictions:
- 0-3 months / 3-6 months / 6-12 months / 1-2 years / 2-5 years

If not provided, ASK:
"What time horizon do you want to predict emerging trends for? (e.g., next 6 months, next 1 year, next 5 years)"

This determines which analytical methodology to apply (short/medium/long-term approach).

---

## VALIDATION CRITERIA

- [ ] Time horizon specified and methodology adapted accordingly
- [ ] Trend predictions include confidence scoring and invalidation triggers
- [ ] Investment opportunities are tiered with specific entry guidance
- [ ] Risk monitoring framework includes clear exit signals

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
