<!--
TRACTION METRICS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See traction-metrics/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Traction Quality: Exceptional (9-10) / Strong (7-8) / Moderate (5-6) / Weak (3-4) / Concerning (1-2)
- Traction Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from traction perspective)
- Confidence: HIGH / MEDIUM / LOW
- PMF Assessment: Strong PMF / Emerging PMF / Weak PMF / No PMF
- Growth Quality: Sustainable / Conditional / Unsustainable
- DAU/MAU: Excellent (>30%) / Good (20-30%) / Moderate (10-20%) / Low (<10%)
- Retention: Strong (>40%) / Moderate (20-40%) / Weak (<20%)
- Organic Mix: Organic-dominated (>60%) / Balanced / Incentive-dependent (>60% incentivized)
- LTV/CAC: Excellent (>5) / Good (3-5) / Marginal (1-3) / Unprofitable (<1)
- Dependency Risk: High (>80% single source) / Medium / Low
- Concentration Risk: High (>80%) / Medium / Low
-->

# {Project Name} - Traction & Growth Metrics

**Topic:** {1 sentence describing the project/protocol}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick investment decision-making
> **Detail level:** concise
> **Format:** Labeled fields covering traction quality, traction implications, PMF, user growth, retention, engagement, organic mix, unit economics, red flags

---

## 1. USER GROWTH ANALYSIS

> **Purpose:** Quantify user base size, growth trajectory, and acquisition sustainability
> **Questions:** How many users? | Growth rate trend? | Acquisition sources? | Sustainable without incentives?
> **Detail level:** standard

### 1.1 Growth Metrics

> **What to deliver:** Current user counts (total, 30d active, 7d active), historical growth trajectory, trend analysis
> **Format:** Metrics with sources, trajectory table, trend assessment (Accelerating/Stable/Decelerating/Declining)

### 1.2 Acquisition Sources

> **What to deliver:** User acquisition channel breakdown with quality metrics per source
> **Format:** Source breakdown table (source, % of users, cost/user, retention), assessment (highest quality, dependency risk, sustainability)

---

## 2. RETENTION COHORT ANALYSIS

> **Purpose:** Measure user retention as primary PMF signal
> **Questions:** What % stay after 30/90 days? | Is curve flattening? | What does this indicate about PMF?
> **Detail level:** detailed

### 2.1 Retention Cohorts

> **What to deliver:** 30-day and 90-day retention cohort data
> **Format:** Cohort tables with size and retention % by month

### 2.2 Retention Analysis

> **What to deliver:** Retention performance interpretation, curve shape analysis, churn data, PMF conclusion
> **Format:** Current metrics, curve analysis (flattening = PMF), churn trends, PMF assessment with evidence
> **Note:** PMF benchmarks defined in objectives.md

---

## 3. ENGAGEMENT DEPTH

> **Purpose:** Measure engagement quality beyond vanity metrics
> **Questions:** How sticky is the product (DAU/MAU)? | Transaction frequency? | Power user concentration risk?
> **Detail level:** standard

### 3.1 Stickiness Metrics

> **What to deliver:** Active user ratios (DAU/WAU/MAU, DAU/MAU ratio), transaction frequency metrics
> **Format:** Metrics with benchmarks, transaction activity summary

### 3.2 User Segmentation

> **What to deliver:** User breakdown by engagement level (power/active/casual), concentration risk, engagement quality assessment
> **Format:** Segmentation table, concentration analysis, bot/spam detection

### 3.3 Crypto-Specific Metrics

> **What to deliver:** Token holder retention, TVL stickiness (for DeFi)
> **Format:** Holder metrics, TVL stability analysis
> **Note:** Skip if not applicable to project type

---

## 4. ORGANIC VS INCENTIVIZED GROWTH

> **Purpose:** Assess growth quality by distinguishing genuine demand from incentive-driven adoption
> **Questions:** What % is organic vs incentivized? | How much is mercenary capital? | Would growth survive incentive reduction?
> **Detail level:** standard

### 4.1 Growth Mix

> **What to deliver:** Organic vs incentivized breakdown over time, program-level analysis
> **Format:** Acquisition breakdown table, organic metrics, incentive program analysis

### 4.2 Mercenary Capital

> **What to deliver:** Mercenary capital indicators, dependency risk assessment, sustainability projection
> **Format:** Indicator metrics (retention drop, fast exit, mercenary %), dependency risk rating
> **Note:** Organic benchmarks defined in objectives.md

---

## 5. UNIT ECONOMICS

> **Purpose:** Evaluate per-user profitability and acquisition efficiency
> **Questions:** What is LTV/CAC ratio? | Payback period? | Are unit economics sustainable?
> **Detail level:** standard

### 5.1 LTV/CAC Analysis

> **What to deliver:** LTV calculation (ARPU × lifetime), CAC breakdown (incentives + marketing + partnerships), ratio assessment, payback period
> **Format:** Calculated metrics with methodology, assessment against benchmarks
> **Note:** LTV/CAC and payback benchmarks defined in objectives.md

### 5.2 Cohort Profitability

> **What to deliver:** Historical cohort profitability analysis, overall economics health
> **Format:** Cohort P/L table, economics assessment (profitable/path to profitability/unprofitable)

---

## 6. FINANCIAL METRICS

> **Purpose:** Analyze protocol revenue generation and path to profitability
> **Questions:** What are revenue sources? | Growth trajectory? | ARPU trends? | Path to profitability?
> **Detail level:** standard

### 6.1 Revenue Analysis

> **What to deliver:** Revenue breakdown by source, growth trajectory, ARPU analysis
> **Format:** Revenue source table, growth table, ARPU metrics with trends

### 6.2 Profitability

> **What to deliver:** Cost structure, P/L summary, profitability status
> **Format:** Cost breakdown, net margin, status (Profitable/Path to profitability/Unprofitable)

---

## 7. PMF SIGNAL VALIDATION

> **Purpose:** Triangulate multiple PMF signals into evidence-backed conclusion
> **Questions:** Is there genuine PMF? | How strong is the evidence? | Is PMF improving or declining?
> **Detail level:** standard

### 7.1 PMF Scorecard

> **What to deliver:** Multi-signal PMF assessment (retention, organic growth, DAU/MAU, product-led growth, user satisfaction), overall PMF rating, evidence, trajectory
> **Format:** Signal scorecard table with performance and PMF strength, overall rating with rationale and trend

---

## 8. RED FLAGS & RISK ASSESSMENT

> **Purpose:** Identify critical risks threatening traction sustainability
> **Questions:** What are the red flags? | What is the risk severity? | What does the bear case look like?
> **Detail level:** detailed

### 8.1 Red Flags by Category

> **What to deliver:** Red flag checklist across Growth, Retention, Engagement, Organic Growth, Unit Economics, Financial
> **Format:** Categorized checkbox list with threshold indicators

### 8.2 Risk Matrix

> **What to deliver:** Prioritized risk assessment with probability, impact, severity, mitigation
> **Format:** Risk matrix table, summary counts (critical/high/medium risks)

### 8.3 Bear Case

> **What to deliver:** Failure scenarios with probability, aggregate risk distribution
> **Format:** Numbered scenarios with probability %, aggregate (sustain/plateau/fail) percentages

---

## 9. COMPETITIVE BENCHMARKING

> **Purpose:** Position project metrics against comparable protocols
> **Questions:** How does project rank vs competitors? | Leading or lagging? | Gap to leader?
> **Detail level:** standard

### 9.1 Comprehensive Comparison

> **What to deliver:** Full metric comparison vs 2-3 comparable protocols, position assessment, gap-to-leader analysis
> **Format:** Multi-metric comparison table (users, growth, retention, DAU/MAU, organic %, revenue, LTV/CAC), position summary, gap analysis

---

## 10. INVESTMENT IMPLICATIONS

> **Purpose:** Synthesize traction analysis into investment implications
> **Questions:** What is overall traction quality? | What are investment implications? | What to monitor?
> **Detail level:** concise

> **What to deliver:**
> - **Traction Implications:** POSITIVE / NEUTRAL / NEGATIVE (from traction perspective)
>   - POSITIVE: Strong PMF, sustainable growth, healthy unit economics (Quality 7+)
>   - NEUTRAL: Emerging PMF, conditional growth quality, path to profitability (Quality 5-6)
>   - NEGATIVE: Weak/no PMF, incentive-dependent, unsustainable economics (Quality <5)
> - **Quality Rating:** 1-10 score with tier (Exceptional/Strong/Moderate/Weak/Concerning)
> - **Rationale:** Top 3-5 strengths and weaknesses with evidence
> - **Growth Quality:** Sustainable vs incentive-dependent assessment
> - **Monitoring Priorities:** Key metrics to track, warning signals
> **Format:** Traction implications rating with quality score, rationale, and monitoring framework
> **Note:** This is traction-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-10

---

## SOURCES & REFERENCES

### Primary Sources
{Blockchain explorer, Dune Analytics, Token Terminal, on-chain data}

### Secondary Sources
{Competitor analysis, market research}

### Tertiary Sources
{Community discussions}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
