# TRACTION & METRICS ANALYSIS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Traction & Metrics Analysis (traction-metrics)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Conduct comprehensive traction and metrics analysis to validate product-market fit and sustainable growth trajectory. Analyze user growth focusing on rate and sources, conduct retention cohort analysis, distinguish organic vs incentivized growth, assess engagement depth, calculate unit economics, validate PMF signals, analyze financial metrics, benchmark vs category standards, and identify red flags. Enable informed decisions about PMF strength and growth quality.

---

## OBJECTIVES

1. **User Growth Analysis** - Total users, growth rates, acquisition sources, sustainability, competitive position

2. **Retention Cohort Analysis** - 30/90-day retention, cohort curves, churn analysis, PMF validation through retention benchmarks

3. **Engagement Depth** - DAU/MAU stickiness, transaction frequency, user segmentation, engagement quality vs bots

4. **Organic vs Incentivized Growth** - Growth mix breakdown, mercenary capital identification, dependency risk assessment

5. **Unit Economics** - LTV calculation, CAC breakdown, LTV/CAC ratio, payback period, cohort profitability

6. **Financial Metrics** - Revenue sources, growth trajectory, ARPU analysis, profitability path, competitive benchmarking

7. **PMF Signal Validation** - Triangulate retention, organic growth %, engagement, product-led growth evidence, user satisfaction

8. **Red Flags Identification** - Growth, retention, engagement, organic, unit economics, and financial risk factors

9. **Competitive Benchmarking** - Compare all key metrics vs 3-5 comparable protocols across growth, retention, engagement, financial

10. **Multi-Source Validation** - Cross-validate all metrics from 2+ independent sources, verify data freshness and quality

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

**Philosophy:** PMF-focused (retention is #1 signal) | Organic growth validation (mercenary capital ≠ PMF) | Engagement depth (DAU/MAU over vanity metrics) | Unit economics (profitability per user) | Multi-source verification | Competitive benchmarking

### BENCHMARK THRESHOLDS

**PMF Retention:** >40% (Strong), 20-40% (Emerging), <20% (Weak)
**Organic Growth:** >50% (Strong demand), 30-50% (Moderate), <30% (Weak)
**DAU/MAU:** >30% (Excellent), 20-30% (Good), 10-20% (Moderate), <10% (Low)
**LTV/CAC:** >3 (Excellent), 2-3 (Good), 1-2 (Marginal), <1 (Unprofitable)
**Payback Period:** <12mo (Excellent), 12-24mo (Good), 24-36mo (OK), >36mo (Concerning)

**Traction Quality Rating:**
- 9-10: Exceptional (Strong PMF >50%, high organic >50%, profitable)
- 7-8: Strong (Solid PMF 40-50%, good organic 30-50%, viable economics)
- 5-6: Moderate (Emerging PMF 20-40%, moderate organic 10-30%)
- 3-4: Weak (Weak PMF <20%, low organic <10%, unprofitable)
- 1-2: Concerning (No PMF, incentive-dependent, declining)

---

## VALIDATION CRITERIA

- [ ] Retention cohorts: 30-day + 90-day metrics
- [ ] Growth mix: Organic % vs Incentivized % breakdown
- [ ] PMF validation: Retention + Organic + Engagement signals triangulated

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
