<!--
TOKENOMICS ANALYSIS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See tokenomics-analysis/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Tokenomics Quality: Optimal (9-10) / Strong (7-8) / Adequate (5-6) / Concerning (3-4) / Broken (1-2)
- Tokenomics Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from tokenomics perspective)
- Confidence: HIGH / MEDIUM / LOW
- Utility Strength: Strong / Moderate / Weak / Forced
- Value Accrual: Robust / Moderate / Weak / None
- Distribution Fairness: Fair / Balanced / Insider-Heavy / Concerning
- Death Spiral Risk: Low / Medium / High / Critical
- Revenue Sustainability: Sustainable / Conditional / Unsustainable
- Vesting Strength: Strong / Adequate / Weak / None
- Inflation Rate: Low (<10%) / Moderate (10-30%) / High (30-100%) / Extreme (>100%)
- Alignment: Strongly Aligned / Moderately Aligned / Misaligned / Severely Misaligned
-->

# {Token Name} - Tokenomics Analysis

**Topic:** {1 sentence describing the token and protocol}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick tokenomics assessment
> **Detail level:** concise
> **Format:** Labeled fields covering quality rating, tokenomics implications, utility, value accrual, distribution, death spiral, sustainability, red flags

---

## 1. TOKEN UTILITY ASSESSMENT

> **Purpose:** Validate token necessity and utility strength
> **Questions:** Is token genuinely required? | What are the use cases? | Could alternatives replace it? | How strong is utility vs benchmarks?
> **Detail level:** standard

### 1.1 Token Overview

> **What to deliver:** Basic token information (name, ticker, chain, standard, supply, launch date) and type classification
> **Format:** Structured fields with sources

### 1.2 Utility Necessity Validation

> **What to deliver:** Assessment of each claimed use case with necessity test, forced token test (3 critical questions)
> **Format:** Per use case: claim, necessity assessment (Genuinely required/Could use alternatives/Forced), rationale
> **Note:** Distinguish genuine utility from artificial insertion

### 1.3 Utility Strength Assessment

> **What to deliver:** Overall utility strength rating with comparison to benchmarks
> **Format:** Strength rating, rationale, benchmark comparison

---

## 2. DISTRIBUTION & VESTING ANALYSIS

> **Purpose:** Assess allocation fairness and unlock timeline
> **Questions:** How is supply allocated? | Is distribution fair? | What are vesting schedules? | When do major unlocks occur?
> **Detail level:** detailed

### 2.1 Token Allocation Breakdown

> **What to deliver:** Complete allocation table across all stakeholder categories
> **Format:** Table with Category, Allocation %, Tokens, Notes. Include verification sources

### 2.2 Distribution Fairness Assessment

> **What to deliver:** Insider vs community ratio analysis with fairness rating
> **Format:** Allocation breakdown, ratio calculation, fairness rating, benchmark comparison
> **Note:** Typical benchmarks: 20-30% insider, 60-70% community

### 2.3 Vesting & Unlock Analysis

> **What to deliver:** Vesting schedules for team/investors/public, unlock timeline projection (12-24mo), major unlock events, sell pressure assessment
> **Format:** Vesting details per category, unlock schedule table, major events list, sell pressure by timeframe
> **Note:** Verify from contracts, not just whitepaper. Short/no vesting is major red flag

---

## 3. EMISSIONS MODELING & INFLATION ANALYSIS

> **Purpose:** Model emissions impact on supply and price
> **Questions:** What is emissions schedule? | How fast does supply grow? | What is inflation rate? | What is sell pressure from emissions?
> **Detail level:** detailed

### 3.1 Supply Metrics

> **What to deliver:** Total supply, initial supply, current supply (if launched)
> **Format:** Structured fields with sources

### 3.2 Emissions Schedule

> **What to deliver:** All emission sources with rates and purpose, total emissions rate
> **Format:** Per emission source: allocation, rate, duration, purpose. Total daily/monthly/annual emissions

### 3.3 Circulating Supply Projections

> **What to deliver:** 12-month and 2-5 year circulating supply projections
> **Format:** Projection tables showing vesting unlocks, emissions, circulating supply, growth %, inflation rate

### 3.4 Inflation Impact Analysis

> **What to deliver:** Sell pressure calculation, inflation rate assessment, dilution impact, emission adjustment mechanisms
> **Format:** Quantified sell pressure, inflation assessment by year, dilution impact on holders

---

## 4. VALUE ACCRUAL MECHANISMS

> **Purpose:** Assess how token captures protocol value
> **Questions:** What are value accrual mechanisms? | Is yield real revenue or emissions? | How strong is value capture? | Are mechanisms sustainable?
> **Detail level:** detailed

### 4.1 Mechanism Analysis

> **What to deliver:** Analysis of each value accrual mechanism with sustainability and strength assessment
> **Format:** Per mechanism: description, revenue source, value flow, sustainability (Real revenue? Yes/No), strength
> **Note:** Distinguish real yield (revenue-backed) from emission yield

### 4.2 Overall Value Accrual Assessment

> **What to deliver:** Aggregate value accrual strength with competitive comparison
> **Format:** Total value quantified, overall strength rating, benchmark comparison

---

## 5. DEATH SPIRAL RISK ASSESSMENT

> **Purpose:** Model negative feedback loop scenarios and resilience
> **Questions:** What are death spiral scenarios? | What triggers them? | How vulnerable is protocol? | What mitigations exist?
> **Detail level:** detailed

### 5.1 Death Spiral Scenarios

> **What to deliver:** 2-3 detailed cascading failure scenarios with triggers, cascade steps, likelihood
> **Format:** Per scenario: trigger, 5-7 step cascade, likelihood (Low/Medium/High), rationale

### 5.2 Vulnerability Assessment

> **What to deliver:** Key triggers with likelihood/impact, high vulnerability factors, protective factors, overall vulnerability rating
> **Format:** Trigger analysis, vulnerability checklist (both high and low factors), overall rating

### 5.3 Mitigation Mechanisms

> **What to deliver:** Available mitigations with effectiveness, overall mitigation strength, death spiral risk rating
> **Format:** Per mitigation: mechanism, effectiveness. Overall rating with rationale

---

## 6. INCENTIVE ALIGNMENT ANALYSIS

> **Purpose:** Assess stakeholder incentive alignment
> **Questions:** Are team/investor/user/protocol incentives aligned? | What misalignments exist? | Do token holders have real power?
> **Detail level:** standard

### 6.1 Stakeholder Incentive Analysis

> **What to deliver:** Alignment assessment for team, investors, users, protocol
> **Format:** Per stakeholder: holdings/terms, aligned incentives, misaligned incentives, skin in game assessment

### 6.2 Misalignment Risks

> **What to deliver:** Identified misalignments with severity and impact
> **Format:** Per misalignment: description, severity, impact, mitigation if any

### 6.3 Token Holder Rights

> **What to deliver:** Governance power assessment (what can vote on, effectiveness, voting power distribution)
> **Format:** Governance power analysis, real vs theater assessment, token holder power rating

### 6.4 Overall Incentive Alignment

> **What to deliver:** Aggregate alignment assessment with key risks and strengths
> **Format:** Overall rating, rationale synthesizing all stakeholders

---

## 7. REVENUE SUSTAINABILITY ANALYSIS

> **Purpose:** Model protocol revenue vs incentive costs and path to profitability
> **Questions:** What is protocol revenue? | What are incentive costs? | Does revenue cover costs? | What is path to profitability?
> **Detail level:** detailed

### 7.1 Protocol Revenue

> **What to deliver:** Revenue sources breakdown with trends, total revenue, revenue quality assessment
> **Format:** Per source: description, current revenue, trend. Total and quality assessment

### 7.2 Incentive Costs

> **What to deliver:** Token incentive expenditures breakdown, total cost
> **Format:** Per program: daily/monthly cost, purpose. Total monthly/annual cost

### 7.3 Revenue vs Incentive Analysis

> **What to deliver:** Coverage ratio calculation, sustainability assessment
> **Format:** Revenue, costs, coverage ratio, interpretation (>100% sustainable, 50-100% conditional, <50% unsustainable)

### 7.4 Sustainability Timeline

> **What to deliver:** Profitability projections under multiple scenarios (3-4 scenarios)
> **Format:** Per scenario: assumptions, breakeven date, feasibility

### 7.5 Treasury & Runway Analysis

> **What to deliver:** Treasury holdings, monthly burn rate, runway calculation, profitability path
> **Format:** Treasury value, burn rate, runway months, recommended path

---

## 8. RED FLAGS & RISK ASSESSMENT

> **Purpose:** Comprehensive risk identification across all dimensions
> **Questions:** What are critical red flags? | How severe and likely are they? | What are failure scenarios?
> **Detail level:** standard

### 8.1 Critical Red Flags by Category

> **What to deliver:** Red flags across 6 categories (Utility, Distribution, Emissions, Value Accrual, Death Spiral, Misalignment)
> **Format:** Per category: checklist with evidence and severity for each flagged item

### 8.2 Risk Matrix

> **What to deliver:** Risk prioritization with probability, impact, mitigation, timeline
> **Format:** Risk table with severity assessment, summary counts

### 8.3 Bear Case Analysis

> **What to deliver:** Failure scenarios with probability, devil's advocate questions, survival assessment
> **Format:** Scenarios with probability %, critical questions, probability distribution (thrive/moderate/fail)

---

## 9. INVESTMENT IMPLICATIONS

> **Purpose:** Synthesize tokenomics analysis into investment implications
> **Questions:** What is overall tokenomics quality? | What are investment implications? | What to monitor?
> **Detail level:** concise

> **What to deliver:**
> - **Tokenomics Implications:** POSITIVE / NEUTRAL / NEGATIVE (from tokenomics perspective)
>   - POSITIVE: Strong tokenomics support investment thesis (Quality 7+, sustainable, aligned)
>   - NEUTRAL: Tokenomics neither helps nor hurts (Quality 5-6, conditional sustainability)
>   - NEGATIVE: Tokenomics is a red flag or drag on investment (Quality <5, death spiral risk, misaligned)
> - **Quality Rating:** 1-10 score with tier (Optimal/Strong/Adequate/Concerning/Broken)
> - **Rationale:** Top 3-5 strengths and weaknesses with evidence
> - **Value Accrual Strength:** How well token captures protocol value
> - **Monitoring Priorities:** Key metrics to track, warning signals
> **Format:** Tokenomics implications rating with quality score, rationale, and monitoring framework
> **Note:** This is tokenomics-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-9

---

## SOURCES & REFERENCES

### Primary Sources
{Whitepaper, smart contracts, on-chain data, official docs, audit reports}

### Secondary Sources
{Token Terminal, Messari, Dune Analytics, research reports}

### Tertiary Sources
{Community discussions, AMAs, social media, news}

### Data Providers
{Block explorers, CoinGecko, on-chain analytics}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
