<!--
TECHNOLOGY ANALYSIS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See technology-analysis/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Technical Quality: Excellent / Good / Moderate / Concerning / Poor
- Technical Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from technical perspective)
- Confidence: HIGH / MEDIUM / LOW
- Innovation Level: Breakthrough / Significant / Incremental / Standard / Fork
- Security Rating: Excellent / Good / Moderate / Weak / Critical Issues
- Maturity: Production-ready / Beta / Alpha / Prototype / Conceptual
- Risk Severity: Critical / High / Medium / Low
- Audit Status: Comprehensive / Partial / Minimal / None
-->

# {Project Name} - Technology Analysis

**Topic:** {Project name} technical evaluation
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick technical assessment
> **Detail level:** concise
> **Format:** Labeled fields covering Technical quality, Technical implications, Tech stack summary, Critical findings, Key risks

---

## 1. TECH STACK & ARCHITECTURE

> **Purpose:** Map technology stack, components, and system architecture
> **Questions:** What technologies is it built on? | What are the core components? | How do they connect? | External dependencies?
> **Detail level:** detailed

### 1.1 Core Tech Stack

> **What to deliver:** Languages, frameworks, blockchain platform, core technologies
> **Format:** Categorized inventory with version/status where relevant

### 1.2 System Architecture

> **What to deliver:** Components, layers, how they interact
> **Format:** Component breakdown, architecture description, diagrams reference if available
> **Note:** AI adapts focus based on project type (L1/L2, DeFi, Infrastructure, Wallet, etc.)

### 1.3 External Dependencies

> **What to deliver:** Third-party services, chain dependencies, oracles, bridges, critical integrations
> **Format:** Dependency inventory with risk assessment

---

## 2. MECHANISM DESIGN

> **Purpose:** Explain how the technology works - core mechanisms and workflows
> **Questions:** What is the core mechanism? | How do key processes work? | Incentive design?
> **Detail level:** detailed

### 2.1 Core Mechanism

> **What to deliver:** Primary mechanism that makes the project function
> **Format:** Clear explanation with technical depth appropriate to mechanism complexity
> **Note:** This is the heart of technical analysis - must clearly explain HOW the project works

### 2.2 Key Workflows

> **What to deliver:** Main processes and flows (transaction flow, liquidation, data delivery, etc.)
> **Format:** Process descriptions, flow explanations

### 2.3 Incentive Design

> **What to deliver:** Economic incentives integrated with mechanism, tokenomics-tech integration
> **Format:** Incentive structure, game theory assessment
> **Note:** Optional - include only if mechanism has significant incentive component

---

## 3. SECURITY POSTURE

> **Purpose:** Evaluate security through audits, vulnerabilities, and trust assumptions
> **Questions:** Audit coverage and quality? | Known vulnerabilities? | Attack vectors? | Trust assumptions?
> **Detail level:** detailed

### 3.1 Audit Assessment

> **What to deliver:** Audit firms, scope, findings severity, remediation status
> **Format:** Audit summary, findings breakdown by severity

### 3.2 Vulnerabilities & Attack Vectors

> **What to deliver:** Known vulnerabilities, potential attack vectors, exploit history
> **Format:** Vulnerability inventory, attack vector analysis

### 3.3 Trust Assumptions

> **What to deliver:** What must be trusted for the system to work securely
> **Format:** Trust assumption inventory with risk implications

---

## 4. TECHNICAL IMPLEMENTATION

> **Purpose:** Assess code quality, development activity, and technical maturity
> **Questions:** Development activity? | Code quality? | Documentation? | Technical debt? | Developer ecosystem?
> **Detail level:** concise

### 4.1 Development Activity

> **What to deliver:** GitHub metrics, contributor activity, development velocity
> **Format:** Key metrics, activity assessment

### 4.2 Code Quality & Documentation

> **What to deliver:** Code standards, test coverage, documentation quality, SDK/tooling
> **Format:** Quality assessment across dimensions

### 4.3 Technical Maturity

> **What to deliver:** Overall maturity assessment, technical debt, production readiness
> **Format:** Maturity rating with evidence

---

## 5. INNOVATION & DIFFERENTIATION

> **Purpose:** Assess genuine innovation and technical differentiation
> **Questions:** Genuine breakthrough or incremental? | Novel approach? | How does it differ from alternatives?
> **Detail level:** standard

### 5.1 Innovation Assessment

> **What to deliver:** Novelty evaluation - breakthrough vs iteration vs fork
> **Format:** Innovation classification with evidence

### 5.2 Technical Differentiation

> **What to deliver:** What makes this technically different from alternatives
> **Format:** Differentiation points with comparison to alternatives

---

## 6. TECHNICAL RISKS & RED FLAGS

> **Purpose:** Proactively identify technical risks across all dimensions
> **Questions:** Security risks? | Architecture risks? | Implementation risks? | Dependency risks?
> **Detail level:** detailed

### 6.1 Risk Inventory

> **What to deliver:** All identified technical risks categorized (security, architecture, implementation, dependency)
> **Format:** Risk table with category, description, severity, mitigation status

### 6.2 Red Flags

> **What to deliver:** Critical warning signs indicating potential fundamental issues
> **Format:** Red flag list with evidence and implications

---

## 7. TECHNICAL BENCHMARKING

> **Purpose:** Contextualize technical quality vs comparable projects
> **Questions:** How does it compare to peers? | Technical advantages? | Disadvantages?
> **Detail level:** standard

### 7.1 Competitive Comparison

> **What to deliver:** Benchmark against 3-5 comparable projects on relevant dimensions
> **Format:** Comparison matrix, analysis

### 7.2 Technical Position Summary

> **What to deliver:** Overall competitive position, advantages, disadvantages
> **Format:** Position summary with key differentiators

---

## 8. INVESTMENT IMPLICATIONS

> **Purpose:** Translate technical assessment into investment perspective
> **Questions:** Does technology support or undermine investment thesis? | What are critical tech risks? | Is tech an advantage or commodity?
> **Detail level:** concise

> **What to deliver:**
> - **Technical Implications:** POSITIVE / NEUTRAL / NEGATIVE (from technology perspective)
>   - POSITIVE: Strong tech supports investment thesis (Quality Excellent/Good, genuine innovation, secure, production-ready)
>   - NEUTRAL: Tech is adequate but not differentiating (Quality Moderate, standard implementation, acceptable security)
>   - NEGATIVE: Tech is a red flag or competitive disadvantage (Quality Concerning/Poor, security issues, immature)
> - **Rationale:** 3-5 key factors from technical analysis above
> - **Tech as Moat:** Is technology a genuine competitive advantage?
> - **Monitoring Priorities:** Key technical metrics to track, warning signals
> **Format:** Technical implications rating with supporting analysis
> **Note:** This is technology-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-8

---

## SOURCES & REFERENCES

### Primary Sources
{GitHub, docs, audit reports, on-chain data}

### Secondary Sources
{Technical reviews, research reports}

### Tertiary Sources
{Discussions, forums, social media}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
