# TECHNOLOGY & ARCHITECTURE ANALYSIS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Technology & Architecture Analysis (technology-analysis)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Conduct comprehensive technology analysis to validate technical soundness, understand how the project works, assess security robustness, and identify technical risks. Applicable to any crypto project type: L1/L2, DeFi, Infrastructure, Wallet, RWA, AI, and others. Enable informed decisions about technical quality and viability through evidence-based assessment.

---

## OBJECTIVES

1. **Map Tech Stack & Architecture** - Identify core technologies (languages, frameworks, blockchain platform), map system components and how they connect, document external dependencies (oracles, bridges, third-party services), assess architecture design quality and trade-offs. Adapt focus based on project type.

2. **Analyze Mechanism Design** - Explain the core mechanism that makes the project function, document key workflows and processes, analyze incentive design and tokenomics-tech integration (if applicable). This is the heart of technical analysis - clearly explain HOW the project works.

3. **Assess Security Posture** - Review security audits (firms, scope, findings, remediation), identify vulnerabilities and attack vectors relevant to project type, document trust assumptions and what must be trusted for the system to work securely, assess economic security where applicable.

4. **Evaluate Technical Implementation** - Analyze development activity (GitHub metrics, contributors, velocity), assess code quality and documentation, evaluate technical maturity and production readiness, identify technical debt and code quality risks.

5. **Assess Innovation & Differentiation** - Distinguish genuine innovation from incremental improvements, identify technical differentiators vs category alternatives, assess innovation risks (unproven at scale, theoretical assumptions).

6. **Identify Technical Risks & Red Flags** - Proactively identify risks across categories: security, architecture, implementation, dependencies, upgrades. Document red flags that indicate potential fundamental issues. Assess severity and mitigation status.

7. **Conduct Technical Benchmarking** - Benchmark against 3-5 comparable projects on relevant dimensions, identify technical advantages and disadvantages, assess competitive position within category.

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

---

## VALIDATION CRITERIA

- [ ] Tech stack and architecture mapped with appropriate depth for project type
- [ ] Mechanism design clearly explained - reader understands HOW the project works
- [ ] Security posture assessed with audit review and vulnerability analysis
- [ ] Technical risks and red flags proactively identified

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
