<!--
TEAM & INVESTOR ANALYSIS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See team-and-investor-analysis/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Execution Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from execution perspective)
- Confidence: HIGH / MEDIUM / LOW
- Identity Status: Fully doxxed / Partially doxxed / Pseudonymous / Anonymous
- Role Coverage: ✅ Covered / ⚠️ Thin / ❌ Unfilled
- Pattern Assessment: Proven track record / Emerging / First major project / Vaporware pattern
- Velocity: Strong / Moderate / Weak / Concerning
- Investor Tier: Tier-1 VC / Tier-2 VC / Angel / Strategic / Corporate VC
- Conviction Signal: High (>70% follow-on) / Moderate (40-70%) / Low (<40%) / Red flag (major exit)
- Funding Adequacy: Well-funded / Adequate / Underfunded / Critical
- Alignment: High / Moderate / Low
- Risk Severity: Critical / High / Medium / Low
-->

# {Project Name} - Team & Investor Analysis

**Topic:** {1 sentence describing the project}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick decision-making
> **Detail level:** concise
> **Format:** Labeled fields organized by dimension - Execution Implications, Team quality (strengths, weaknesses, track record), Investor backing (investors, value-add, alignment), Critical factors (success, risk)
> **Note:** Present execution implications → team quality → investor backing → combined capability. Factual assessment - avoid investment-biased language

---

## 1. TEAM OVERVIEW

> **Purpose:** Understand who's building, their backgrounds, and team composition
> **Questions:** Who are founders/key people? | Anonymous or doxxed? | What backgrounds can be verified? | Is team composition appropriate?
> **Detail level:** standard

### 1.1 Founders & Key Contributors

> **What to deliver:** Individual profiles for each founder/key contributor with identity, role, background, crypto experience, domain expertise, red flags
> **Format:** Per person: Identity status + Background (adapt to data availability: doxxed vs pseudonymous) + Crypto experience + Domain expertise + Red flags
> **Note:** Adapt to data availability - many crypto teams are pseudonymous, work with what's verifiable

### 1.2 Team Composition

> **What to deliver:** Team size assessment, key roles coverage (Engineering, Product, Research, Operations), composition assessment, notable members, red flags
> **Format:** Size estimate, role coverage status, composition assessment, notable members list
> **Note:** Exact size often not public - use estimates based on team pages, GitHub, LinkedIn

---

## 2. EXECUTION ASSESSMENT

> **Purpose:** Evaluate execution capability through past track record and current activity
> **Questions:** What outcomes did past projects achieve? | What's current GitHub/roadmap/communication velocity?
> **Detail level:** standard

### 2.1 Track Record

> **What to deliver:** 1-3 notable previous projects with actual outcomes, relevance to current project, pattern assessment
> **Format:** Per project: Name/Role/Years + Outcome (success/failed with metrics) + Relevance + Source. Pattern Assessment
> **Note:** Skip if first project or unverifiable - focus on outcomes not titles

### 2.2 Current Execution Velocity

> **What to deliver:** GitHub activity (commits, contributors, trend), milestone delivery status, communication assessment, velocity evaluation with red flags
> **Format:** GitHub metrics with benchmarks, milestone table, communication channels/frequency, assessment
> **Note:** Adapt to what's public - private repos may have no GitHub metrics

---

## 3. TEAM-PRODUCT FIT

> **Purpose:** Assess whether team expertise matches product requirements
> **Questions:** What expertise does product require? | What team capabilities exist? | What gaps remain? | How are gaps mitigated?
> **Detail level:** standard

### 3.1 Product Requirements

> **What to deliver:** Product complexity assessment, key technical requirements identification (3-5 skills)
> **Format:** Complexity level, skills list

### 3.2 Team Capability Gap Analysis

> **What to deliver:** Skills coverage assessment (table), strengths, critical gaps, mitigation plans, red flags
> **Format:** Skills coverage table (required capability × coverage status × evidence/gap), strengths/gaps analysis

---

## 4. FUNDING ANALYSIS

> **Purpose:** Assess funding health, valuation rationality, and investor conviction signals
> **Questions:** Well-funded for roadmap? | Rational valuation trajectory? | Strong follow-on participation?
> **Detail level:** detailed
> **Note:** For token allocation, vesting, unlocks → See tokenomics-analysis workflow

### 4.1 Funding Overview

> **What to deliver:** Total funding, funding rounds table (round, date, amount, valuation, lead, notable investors), valuation trajectory analysis
> **Format:** Total raised, rounds table, valuation rationality assessment

### 4.2 Conviction & Adequacy

> **What to deliver:** Follow-on participation analysis, conviction signal assessment, funding adequacy and runway, competitive funding comparison, red flags
> **Format:** Follow-on rate, conviction signal, runway assessment, competitive comparison

---

## 5. LEAD INVESTOR PROFILES

> **Purpose:** Validate investor quality and track record
> **Questions:** Are investors top-tier? | Portfolio success rate? | Crypto-native expertise? | Active or passive?
> **Detail level:** detailed

### 5.1 Syndicate Overview

> **What to deliver:** Syndicate composition (tier breakdown), structure (size, concentration), quality assessment, red flags
> **Format:** Overview bullets (composition, structure, quality, red flags)

### 5.2 Lead Investor Analysis

> **What to deliver:** Individual profiles for lead investors + notable/strategic investors (max 10)
> **Format:** Per investor: Profile (type, fund size, stage focus, crypto focus) + Track Record (portfolio success, notable investments) + Reputation + Conviction Signal + Behavior + Red Flags
> **Note:** Prioritize: Lead investors → Strategic investors → High-profile angels → Notable VCs

---

## 6. INVESTOR VALUE-ADD ASSESSMENT

> **Purpose:** Document all value-add investors provide beyond capital
> **Questions:** What support do investors provide? | Does it address team gaps? | Evidence of delivery?
> **Detail level:** standard

### 6.1 Value-Add Overview

> **What to deliver:** Key support areas, breadth/depth, engagement level, gap coverage assessment, red flags
> **Format:** Overview bullets (key areas, depth, engagement, gap coverage)

### 6.2 Value-Add Analysis

> **What to deliver:** Evidence-driven value-add categories with support details, relevance to team gaps, impact assessment
> **Format:** Per category: Category name (based on actual support) + What support provided + Relevance & impact + Source
> **Note:** Evidence-driven - let actual support define categories, not predefined framework

---

## 7. TEAM-INVESTOR ALIGNMENT

> **Purpose:** Assess strategic alignment between team and investors
> **Questions:** Does investor backing validate team quality? | Vision/timeline alignment? | Governance structure healthy?
> **Detail level:** concise

### 7.1 Alignment Analysis

> **What to deliver:** Investor validation assessment, strategic alignment (vision, timeline, governance), misalignments
> **Format:** Validation signal, vision/timeline/governance alignment, misalignments identified

---

## 8. RED FLAGS & RISKS

> **Purpose:** Comprehensive risk identification across team and investor dimensions
> **Questions:** What execution risks exist? | Team capability gaps? | Investor concerns? | Combined risks?
> **Detail level:** detailed

### 8.1 Team Capability Risks

> **What to deliver:** Team-related risks with evidence, severity, impact, mitigation assessment
> **Format:** Per risk: Risk name + Evidence + Severity + Impact + Mitigation

### 8.2 Investor-Related Risks

> **What to deliver:** Investor-related risks with evidence, severity, impact, mitigation assessment
> **Format:** Same structure as team capability risks

### 8.3 Risk Matrix

> **What to deliver:** Prioritized risk table, risk assessment summary
> **Format:** Table (Risk, Probability, Impact, Severity, Mitigation, Timeline), summary counts

### 8.4 Bear Case Analysis

> **What to deliver:** 2-4 failure scenarios with probability, survival probability analysis, devil's advocate questions
> **Format:** Per scenario: Description + Probability + Impact + Triggers. Survival probability breakdown. Questions list

---

## 9. INVESTMENT IMPLICATIONS

> **Purpose:** Synthesize team and investor analysis into investment implications
> **Questions:** What are team strengths/weaknesses? | What investor support exists? | What are the execution implications?
> **Detail level:** concise

> **What to deliver:**
> - **Execution Implications:** POSITIVE / NEUTRAL / NEGATIVE (from execution perspective)
>   - POSITIVE: Strong team with proven track record, top-tier backing, high velocity, aligned interests
>   - NEUTRAL: Adequate team with emerging track record, decent backing, moderate velocity, acceptable alignment
>   - NEGATIVE: Weak team, concerning history, insufficient backing, low velocity, misaligned interests
> - **Team Quality:** Top 3 strengths and weaknesses with evidence
> - **Investor Backing:** Quality tier, total funding, key value-add areas
> - **Rationale:** 3-5 key reasons with evidence from analysis above
> - **Key Catalysts:** Team hires, funding events, milestone deliveries that could shift execution capability
> - **Monitoring Priorities:** Key metrics to track, warning signals
> **Format:** Execution implications rating with supporting rationale and monitoring framework
> **Note:** This is execution-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-9

---

## SOURCES & REFERENCES

### Primary Sources
{LinkedIn, GitHub, Company Website, Crunchbase, Funding Announcements}

### Secondary Sources
{Media Coverage, Research Reports, Investor Websites}

### Tertiary Sources
{AMAs, Community Discussions, Twitter}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
