# TEAM & INVESTOR ANALYSIS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Team & Investor Analysis (team-and-investor-analysis)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Conduct comprehensive team and investor analysis to assess execution capability through dual lenses: team quality and investor backing. Validate founder backgrounds with multi-source verification, evaluate core team technical depth, verify track records through outcome analysis, assess execution velocity with evidence, analyze funding history and investor conviction signals, profile lead investors and their track records, evaluate investor value-add beyond capital through evidence-driven gap coverage analysis, assess team-investor strategic alignment and validation signals, identify team-product fit gaps, surface red flags across both team and investor dimensions, and capture additional research findings beyond template structure. Provide factual synthesis of combined execution capability WITHOUT investment recommendations - enabling separate investment decisions based on specific investment frameworks.

---

## OBJECTIVES

1. **Assess Team Overview** - Identify founders and key contributors (doxxed vs pseudonymous), work with verifiable information flexibly, assess crypto-native experience and domain expertise, evaluate team composition and size appropriateness, identify critical role coverage, assess team identity risks, and identify team composition red flags

2. **Evaluate Execution Assessment** - Verify previous project track record with outcome analysis, assess current execution velocity through observable metrics, evaluate milestone delivery against roadmap, measure communication consistency and transparency, benchmark execution vs competitors, identify execution red flags

3. **Evaluate Team-Product Fit** - Identify product technical requirements and complexity level, assess whether observable team expertise matches product needs, map required capabilities to team coverage with gap analysis, identify critical skill gaps and severity, evaluate mitigation plans for gaps, assess team size appropriateness

4. **Analyze Funding History** - Document complete funding history (rounds, amounts, dates, valuation progression, investors), assess funding adequacy and runway sustainability, evaluate valuation trajectory rationality, analyze investor conviction through follow-on participation, detect funding red flags

5. **Profile Lead Investors & Track Records** - Profile all lead investors plus notable/strategic investors (max 10 total), verify backgrounds and crypto-specific expertise, track records, reputation and category expertise, post-investment behavior patterns, thesis alignment, quality tier assessment, investor-specific red flags

6. **Assess Investor Value-Add Beyond Capital** - Identify all forms of support investors provide through evidence-driven analysis, evaluate support across whatever areas exist, assess relevance to project needs and team gaps, measure investor engagement level, evaluate gap-filling effectiveness, provide overall value-add quality assessment

7. **Evaluate Team-Investor Alignment** - Assess investor backing as team validation signal, evaluate strategic alignment between team vision and investor thesis, analyze governance and decision-making structure, identify potential misalignments, assess investor syndicate cohesion, validate mutual commitment signals

8. **Surface Red Flags & Risks Across All Dimensions** - Proactively identify team capability, execution, credibility, team dynamics, investor, and funding red flags, assess combined risk matrix with probability-weighted impact

9. **Assess Combined Execution Capability** - Synthesize team quality summary, evaluate investor backing summary, analyze team-investor combination through factual synthesis, identify critical success and risk factors, compare to competing projects. Provide factual assessment WITHOUT investment recommendations

10. **Document Additional Research Findings** - Capture important findings that don't fit existing template sections, provide source and context, explain relevance. Optional section - only include if notable findings exist

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

**Philosophy:** Evidence-based validation (multi-source verification) + Outcome analysis (results not titles) + Team-product fit (expertise matches requirements) + Investor quality assessment (track records, value-add, alignment) + Team-investor synergy (combined execution capability) + Proactive red flags (capability gaps, execution risks, investor concerns, funding risks)

---

## VALIDATION CRITERIA

- [ ] Founder backgrounds validated from 2+ independent sources (LinkedIn, GitHub, media coverage)
- [ ] Track records verified through outcome analysis (not just titles - verify project success, individual contribution)
- [ ] Execution velocity assessed with evidence (GitHub activity, milestone delivery, communication patterns)
- [ ] Funding history documented with complete data (rounds, amounts, dates, valuations, lead investors)
- [ ] Investor profiles verified with track record evidence (portfolio success rate, expertise validation)
- [ ] Investor value-add documented with evidence (support categories, gap coverage, engagement level)
- [ ] Team-investor alignment assessed (validation signals, strategic fit, governance structure)
- [ ] Red flags proactively identified across ALL dimensions
- [ ] Combined execution capability assessment is FACTUAL synthesis without investment recommendations

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`

---

*Philosophy: Evidence-based validation (multi-source verification) + Outcome analysis (results not titles) + Team-product fit (expertise matches requirements) + Investor quality assessment (track records, value-add, alignment) + Team-investor synergy (combined execution capability) + Proactive red flags (capability gaps, execution risks, investor concerns, funding risks)*
