<!--
SOCIAL SENTIMENT TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See social-sentiment/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Community Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from community perspective)
- Community Health: 1-10 (Excellent 9-10 / Good 7-8 / Moderate 5-6 / Concerning 3-4 / Poor 1-2)
- Confidence: HIGH / MEDIUM / LOW
- Engagement Rate: Excellent / Good / Moderate / Low
- Authenticity: Excellent (<5% fake) / Good (5-10%) / Moderate (10-20%) / High (>20% fake)
- Sentiment Trend: Improving / Stable / Declining
- Sustainability: Self-organizing / Partially independent / Team-dependent
- Platform Risk: Diversified / Concentrated / Single platform dependency
- Governance Health: 1-10
- Centralization: Decentralized / Moderate / High / Critical
-->

# {Project Name} - Social Sentiment & Community Analysis

**Topic:** {1 sentence describing the project and community}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for investment decision-making on community quality
> **Detail level:** concise
> **Format:** Labeled fields covering Community Implications, Health rating, Quick stats (size, sentiment, authenticity, governance), Critical strengths, Critical risks

---

## 1. COMMUNITY METRICS

> **Purpose:** Quantify community size, growth trajectory, and platform distribution
> **Questions:** How big? | Growing or declining? | Organic or bought? | Platform concentration risk?
> **Detail level:** standard

### 1.1 Platform Overview

> **What to deliver:** Current size and activity across platforms (Twitter, Discord, Telegram), total unique community estimate, platform risk assessment
> **Format:** Summary table with metrics per platform, total estimate, risk assessment

### 1.2 Growth Analysis

> **What to deliver:** Growth trajectory, growth composition (organic vs incentive-driven vs fake), anomalies detected, sustainability assessment
> **Format:** Trend analysis with driver breakdown

---

## 2. SENTIMENT ANALYSIS

> **Purpose:** Assess community sentiment quality and authenticity
> **Questions:** Positive or negative? | Genuine or coordinated? | What drives sentiment?
> **Detail level:** standard

### 2.1 Sentiment Distribution

> **What to deliver:** Current sentiment breakdown (positive/neutral/negative %), trend over time
> **Format:** Distribution metrics, trend table with drivers

### 2.2 Sentiment Drivers & Authenticity

> **What to deliver:** Positive drivers, negative drivers (with evidence), authenticity check (coordinated shilling/FUD detection)
> **Format:** Driver list, authenticity assessment

---

## 3. ENGAGEMENT & AUTHENTICITY

> **Purpose:** Evaluate engagement quality and detect fake activity
> **Questions:** Real engagement or bots? | Quality discussions? | Fake follower %?
> **Detail level:** detailed

### 3.1 Engagement Metrics

> **What to deliver:** Cross-platform engagement rates (Twitter engagement rate, Discord DAU/MAU, response rate)
> **Format:** Platform metrics with benchmarks
> **Note:** Benchmarks defined in objectives.md

### 3.2 Bot & Fake Activity Detection

> **What to deliver:** Fake follower estimates per platform with method and indicators, overall authenticity rating
> **Format:** Bot metrics with evidence and method

### 3.3 Discussion Quality

> **What to deliver:** Content mix (technical/support/price talk/spam), power user concentration, engagement quality assessment
> **Format:** Discussion breakdown, concentration analysis

---

## 4. GOVERNANCE HEALTH

> **Purpose:** Assess governance participation and decentralization
> **Questions:** Voter turnout? | Whale control? | Quality proposals? | Trend?
> **Detail level:** standard
> **Note:** Skip if project has no governance

### 4.1 Participation Metrics

> **What to deliver:** Governance platform, voter turnout (average, unique voters, trend), proposal activity (volume, quality)
> **Format:** Key metrics with trends

### 4.2 Centralization Analysis

> **What to deliver:** Voting power distribution (top 1/10/100 holders), whale dominance, centralization level, governance health rating
> **Format:** Concentration metrics, risk assessment

---

## 5. COMMUNITY QUALITY

> **Purpose:** Assess community sustainability and alignment
> **Questions:** Sustainable without team? | Resilient to adversity? | Aligned with product?
> **Detail level:** standard

### 5.1 Sustainability Indicators

> **What to deliver:** User-generated content, unpaid contributors, member tenure, self-sustainability assessment
> **Format:** Key sustainability metrics

### 5.2 Resilience & Alignment

> **What to deliver:** Crisis resilience (recent test, retention through adversity), product alignment (actual users %, long-term holders, value understanding), community quality rating
> **Format:** Resilience evidence, alignment metrics

---

## 6. COMPETITIVE POSITION

> **Purpose:** Benchmark community metrics against comparable protocols
> **Questions:** Larger or smaller? | Better engagement? | Stronger or weaker community?
> **Detail level:** standard

### 6.1 Benchmark Comparison

> **What to deliver:** Multi-metric comparison vs 2-3 comparable protocols (size, engagement, authenticity, sentiment, governance)
> **Format:** Comprehensive comparison table

### 6.2 Position Summary

> **What to deliver:** Competitive advantages, disadvantages, overall position, gap to leader
> **Format:** Strength/weakness bullets, overall position

---

## 7. INVESTMENT IMPLICATIONS

> **Purpose:** Synthesize community analysis into investment implications
> **Questions:** What are the community implications for investment? | What are key reasons? | What to monitor?
> **Detail level:** concise

> **What to deliver:**
> - **Community Implications:** POSITIVE / NEUTRAL / NEGATIVE (from community perspective)
>   - POSITIVE: Strong engagement, high authenticity, self-sustaining, positive sentiment trajectory
>   - NEUTRAL: Moderate engagement, acceptable authenticity, team-dependent, stable sentiment
>   - NEGATIVE: Low engagement, high fake activity, fragile community, declining sentiment
> - **Rationale:** 3-5 key reasons with evidence from analysis above
> - **Key Catalysts:** Community events, campaigns, or changes that could shift sentiment
> - **Monitoring Priorities:** Key metrics to track, warning signals
> **Format:** Community implications rating with supporting rationale and monitoring framework
> **Note:** This is community-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-7

---

## SOURCES & REFERENCES

### Primary Sources
{Twitter Analytics, Discord Stats, Governance Platform}

### Secondary Sources
{Bot Detection Tools, Social Listening Reports}

### Tertiary Sources
{Community Discussions}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
