# SOCIAL SENTIMENT & COMMUNITY ANALYSIS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Social Sentiment & Community Analysis (social-sentiment)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Conduct comprehensive social sentiment and community analysis to assess quality, engagement authenticity, and governance health. Track community size and growth, analyze sentiment distribution, evaluate engagement quality, distinguish organic vs manufactured hype, assess governance participation, identify red flags, and benchmark metrics. Enable informed decisions about community strength and sustainability.

---

## OBJECTIVES

1. **Community Size & Growth Analysis** - Platform tracking, growth rates, sustainability assessment, anomaly detection, competitive benchmarking

2. **Sentiment Distribution Assessment** - Social listening, positive/negative/neutral classification, driver identification, trend tracking, authenticity validation

3. **Engagement Quality Evaluation** - Engagement rates, discussion quality, responsiveness metrics, power user analysis, fake engagement detection

4. **Organic vs Manufactured Analysis** - Bot detection, paid campaign tracking, follower authenticity, organic indicators, hype quantification

5. **Governance Participation Assessment** - Voter turnout tracking, proposal quality, forum discussions, community voice representation, centralization analysis

6. **Community Health Analysis** - Cohesion assessment, toxicity evaluation, diversity analysis, resilience measurement, sustainability indicators, project alignment

7. **Social Red Flags Identification** - Bot armies, pump groups, paid campaigns, fake engagement, toxic behavior, manipulation severity

8. **Competitive Benchmarking** - Size comparison, engagement benchmarking, sentiment positioning, governance comparison, advantage/gap identification

9. **Multi-Source Validation** - Platform API verification, social listening tools, bot detection validation, balanced perspective, confidence assessment

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

**Philosophy:** Engagement authenticity (bot detection required) | Sentiment evidence (social listening tools) | Organic vs manufactured (fake follower detection) | Governance health (participation and decentralization) | Proactive red flags (bot armies, pump groups, toxic behavior)

### BENCHMARK THRESHOLDS

**Twitter Engagement:** >3% (Excellent), 1-3% (Good), 0.5-1% (Moderate), <0.5% (Low)
**Discord Activity:** >500 msg/day (Active), 100-500 (Moderate), <100 (Low)
**Discord DAU/MAU:** >20% (Good), 10-20% (Moderate), <10% (Low)
**Fake Activity %:** <5% (Excellent), 5-10% (Good), 10-20% (Moderate), >20% (High risk)
**Organic %:** >70% (Highly organic), 50-70% (Mostly organic), 30-50% (Mixed), <30% (Manufactured)
**Governance Turnout:** >30% (Excellent), 15-30% (Good), 5-15% (Moderate), <5% (Low)
**Top 10 Control:** <30% (Decentralized), 30-50% (Moderate), 50-70% (High), >70% (Critical risk)

**Community Health Rating:**
- 8.5-10: Excellent (Best-in-class quality, engagement, health)
- 7.0-8.4: Good (Above-average, strong fundamentals)
- 5.5-6.9: Moderate (Average, acceptable but needs work)
- 4.0-5.4: Concerning (Below-average, significant issues)
- 0-3.9: Poor (Weak/dysfunctional, critical issues)

---

## VALIDATION CRITERIA

- [ ] Sentiment distribution assessed with evidence from social listening across platforms
- [ ] Organic vs manufactured hype distinguished with bot detection analysis
- [ ] Governance participation analyzed with voter turnout and proposal quality metrics

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
