<!--
SECTOR OVERVIEW TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See sector-overview/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Sector Outlook: BULLISH / NEUTRAL / BEARISH (sector-level investment attractiveness)
- Confidence: HIGH / MEDIUM / LOW
- Trajectory: Explosive >100% / High 30-100% / Moderate 10-30% / Slow <10%
- Maturity: Embryonic <$100M / Growth $100M-$5B / Mature >$5B / Declining
- Impact/Severity/Clarity: High / Med / Low
- Status: Active / Strengthening / Weakening
- Stage: Emerging / Peak / Maturing
- Direction: Accelerating / Stable / Decelerating
-->

# {Sector Name} - Sector Overview

**Topic:** {1 sentence describing the sector}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick decision-making
> **Detail level:** concise
> **Format:** Labeled fields covering sector definition, market size, growth, key players, maturity, current state, sector outlook

---

## 1. SECTOR DEFINITION & SCOPE

> **Purpose:** Establish sector boundaries, validate problem-solution fit, explain blockchain value proposition
> **Questions:** What problem does this sector solve? | Why blockchain? | What's in/out of scope?
> **Detail level:** standard

### 1.1 Sector Description

> **What to deliver:** Problem statement, solution approach, blockchain value proposition, sector categorization
> **Format:** Labeled fields or structured paragraphs

### 1.2 Sector Boundaries

> **What to deliver:** Included use cases, excluded use cases with rationale, adjacent sectors
> **Format:** Categorized bullet lists

---

## 2. SECTOR HISTORY & EVOLUTION

> **Purpose:** Document sector formation timeline, key milestones, evolution with market cycle context
> **Questions:** When and why did this sector emerge? | What were the key milestones? | How did it evolve across market cycles?
> **Detail level:** standard

### 2.1 Sector Formation

> **What to deliver:** When emerged, catalyst/need, early pioneers with launch dates
> **Format:** Labeled fields

### 2.2 Key Milestones & Evolution

> **What to deliver:** 4-8 major milestones with event, impact, market context
> **Format:** Chronological entries with consistent structure

### 2.3 Evolution Across Market Cycles

> **What to deliver:** Bull/bear market behavior, resilience assessment, cycle independence level
> **Format:** Labeled sections with bullet points

---

## 3. HOW IT WORKS - SECTOR MECHANICS

> **Purpose:** Explain sector operational mechanisms, participant roles, value flows, risk landscape
> **Questions:** How does this sector work? | Who participates and why? | How is value created? | What are the risks?
> **Detail level:** detailed

### 3.1 Sector Operations

> **What to deliver:** Core mechanism, operational flow, key participants with roles/motivations
> **Format:** Explanatory paragraphs + participant list. Adapt structure to sector's natural flow (linear/parallel/cyclical/network)

### 3.2 Value Creation & User Flow

> **What to deliver:** Value flow, economic model, typical journey, friction points
> **Format:** Labeled fields or flow description

### 3.3 Risk Landscape & Failure Modes

> **What to deliver:** Primary risk vectors with severity/mitigation, systemic dependencies, failure conditions
> **Format:** Structured risk entries + explanatory paragraphs

---

## 4. PARTICIPANT SEGMENTS & USE CASES

> **Purpose:** Identify participant segments, use cases, and motivations
> **Questions:** Who are the primary participants? | What are they doing? | Why do they participate?
> **Detail level:** standard

### 4.1 Primary Participant Segments

> **What to deliver:** 3-5 segments with type, description, proportion, needs; segment trends
> **Format:** Structured profiles per segment

### 4.2 Common Use Cases & Motivations

> **What to deliver:** 5-7 top use cases, primary motivations with evidence
> **Format:** Numbered use cases + bulleted motivations

---

## 5. SECTOR CHARACTERISTICS & DYNAMICS

> **Purpose:** Present current sector state through growth trends, maturity indicators, key dynamics
> **Questions:** How fast is the sector growing? | What maturity stage? | What's driving growth or creating headwinds?
> **Detail level:** detailed

### 5.1 Growth & Maturity

> **What to deliver:** Historical growth (24mo), trajectory, growth quality, maturity stage, maturity indicators, key characteristics
> **Format:** Data table for metrics + labeled fields for assessments

### 5.2 Drivers & Headwinds

> **What to deliver:** 3-5 growth drivers, 2-4 headwinds, net momentum
> **Format:** Bulleted lists with impact/status indicators

---

## 6. KEY TRENDS & RECENT DEVELOPMENTS

> **Purpose:** Document current trends and recent innovations happening NOW
> **Questions:** What are the major trends? | What innovations emerged recently? | What's hot and emerging?
> **Detail level:** standard

### 6.1 Major Trends

> **What to deliver:** 3-5 trends with stage, direction, evidence, significance
> **Format:** Structured entries per trend

### 6.2 Recent Innovations

> **What to deliver:** 3-5 innovations (past 6-12mo) with adoption metrics, structural assessment
> **Format:** Structured entries per innovation

### 6.3 Emerging Segments & Hot Topics

> **What to deliver:** 2-3 emerging segments, 2-3 hot topics with durability assessment
> **Format:** Bulleted lists with key metrics

---

## 7. REGULATORY & POLICY LANDSCAPE

> **Purpose:** Document current regulatory status and active developments
> **Questions:** What's the regulatory status by jurisdiction? | What are active developments? | How is industry responding?
> **Detail level:** standard

### 7.1 Regulatory Status by Jurisdiction

> **What to deliver:** Status for major jurisdictions with regulations and sector impact
> **Format:** Table (jurisdiction × status/regulations/impact)

### 7.2 Active Developments & Risks

> **What to deliver:** Key regulatory developments, risk assessment across dimensions
> **Format:** Numbered developments + categorized risk assessment

### 7.3 Compliance & Industry Response

> **What to deliver:** Major requirements, industry adaptation approaches, trend direction
> **Format:** Bullets for requirements + paragraph for adaptation

---

## 8. SECTOR OUTLOOK

> **Purpose:** Synthesize analysis into sector-level investment outlook
> **Questions:** What's the overall sector outlook? | Is it worth allocating to this sector? | What are the key considerations?
> **Detail level:** concise

> **What to deliver:**
> - **Sector Outlook:** BULLISH / NEUTRAL / BEARISH (sector-level investment attractiveness)
>   - BULLISH: Strong growth fundamentals, favorable dynamics, recommend overweight allocation
>   - NEUTRAL: Mixed signals, stable sector, recommend market-weight allocation
>   - BEARISH: Headwinds outweigh tailwinds, declining metrics, recommend underweight/avoid
> - **Rationale:** 3-5 key factors supporting the outlook
> - **Allocation Considerations:** Risk/reward profile for sector exposure
> - **Top Segments/Plays:** Most attractive sub-segments or approaches within sector
> **Format:** Outlook rating with supporting analysis and actionable considerations
> **Note:** This is sector-level view; for project-specific assessment, use project-snapshot or product-analysis workflows

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-8

---

## SOURCES & REFERENCES

### Primary Sources
{Protocol docs, on-chain data, official announcements}

### Secondary Sources
{Research reports, analytics, industry analyses}

### Tertiary Sources
{News, community discussions}

### Data Providers
{Analytics platforms, market data}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
