<!--
SECTOR LANDSCAPE TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See sector-landscape/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Sector Outlook: BULLISH / NEUTRAL / BEARISH (sector-level view)
- Confidence: HIGH / MEDIUM / LOW
- Score: 1-10 (1-7 compact profile, 8-10 detailed profile)
- Investment Potential: RISK [Very Low/Low/Medium/High/Very High] : REWARD [Very Low/Low/Medium/High/Very High]
- Concentration/Innovation/Maturity: High / Med / Low
- Stage: Mainnet(Live) / Testnet / Devnet / Funding / Paper

MULTI-DIMENSIONAL CLASSIFICATION:
- 2-3 dimensions for standard sectors (up to 5 for complex)
- 1 primary dimension (core market organization)
- 1-2 supplementary dimensions (alternative strategic patterns)
- Each dimension must provide DISTINCT insights
-->

# {Sector Name} - Sector Landscape

**Topic:** {1 sentence describing the sector}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Database overview for systematic project discovery and comparison
> **Detail level:** concise
> **Format:** Labeled fields covering database scope, structural coverage, player coverage, market structure, distribution, sector outlook, key insights

---

## 1. MARKET STRUCTURE OVERVIEW

> **Purpose:** Define multi-dimensional classification framework for organizing sector players
> **Questions:** What structural dimensions organize this market? | What categories exist within each dimension? | What strategic insights does each dimension reveal?
> **Detail level:** standard

### 1.1 Dimension 1: [Primary Dimension Name]

> **What to deliver:** Dimension definition, construction methodology (classification basis, category boundaries, rationale), strategic insight, dimension metrics, structure visualization
> **Format:** Labeled sections. Structure adaptive to dimension type (hierarchy tree, tier table, clustering, spectrum)

### 1.2 Dimension 2: [Second Dimension Name]

> **What to deliver:** Second dimension providing distinct strategic insight from Dimension 1
> **Format:** Same structure as 1.1

### 1.3 Dimension 3: [Optional Third Dimension]

> **What to deliver:** Third dimension if applicable, distinct from Dimensions 1-2
> **Format:** Same structure as 1.1 and 1.2
> **Note:** Optional - include only if provides distinct strategic value

---

## 2. PROJECT DATABASE

> **Purpose:** Comprehensive player profiles organized by primary dimension categories with adaptive detail based on score
> **Questions:** Who are all the players in each category? | What are their key characteristics and metrics? | How do they rank within their category? | What's their investment potential?
> **Detail level:** detailed

### [Category Name]

> **What to deliver:** Category overview (role, metrics, characteristics), ALL players ranked by score, category insights
> **Format:** Three parts per category - Overview (labeled fields), Players (detailed profiles for 8-10/10, compact for 1-7/10 with Other Dimensions field), Insights (leader differentiation, trends, shortlist considerations)
> **Note:** Repeat for each category in primary dimension. Include "Other Dimensions" field for cross-referencing

---

## 3. PROJECTS BY DIMENSIONS

> **Purpose:** Cross-reference view organizing players by supplementary dimensions
> **Questions:** How do players distribute across secondary dimensions? | What patterns emerge from different classification lenses?
> **Detail level:** concise

### 3.1 Dimension 2: [Second Dimension Name]

> **What to deliver:** Categories with brief overview and player lists (name + score only)
> **Format:** Category sections with Overview (definition, characteristics, count) and Projects list (ranked by score)
> **Note:** NO detailed profiles - reference Section 2 for full player information

### 3.2 Dimension 3: [Third Dimension Name]

> **What to deliver:** Same as 3.1 for Dimension 3 if applicable
> **Format:** Same as 3.1
> **Note:** Only include if Dimension 3 was defined in Section 1.3

---

## 4. CROSS-CATEGORY INSIGHTS

> **Purpose:** Document patterns, trends, and relationships spanning across categories and dimensions
> **Questions:** What patterns emerge across the entire market? | What trends are shaping the landscape? | What gaps exist in the ecosystem?
> **Detail level:** standard

### 4.1 Market-Wide Patterns

> **What to deliver:** Concentration patterns, stage distribution, innovation clusters, integration trends
> **Format:** Labeled paragraphs describing patterns and implications

### 4.2 Emerging Trends

> **What to deliver:** 2-3 emerging trends with description, evidence, implications
> **Format:** Structured entries per trend

### 4.3 Ecosystem Gaps

> **What to deliver:** 2-3 identified gaps with evidence, validation, opportunity size, barriers
> **Format:** Structured entries per gap

---

## 5. SECTOR OUTLOOK

> **Purpose:** Synthesize landscape analysis into sector-level investment outlook
> **Questions:** What's the overall sector outlook? | Which categories/projects are most attractive? | What are key considerations?
> **Detail level:** concise

> **What to deliver:**
> - **Sector Outlook:** BULLISH / NEUTRAL / BEARISH (sector-level investment attractiveness)
>   - BULLISH: Strong fundamentals, favorable dynamics, recommend overweight
>   - NEUTRAL: Mixed signals, recommend market-weight
>   - BEARISH: Headwinds outweigh tailwinds, recommend underweight/avoid
> - **Rationale:** 3-5 key factors supporting the outlook
> - **Top Categories:** Most attractive market structure categories
> - **Shortlist Projects:** Top-scored projects across categories for deeper analysis
> **Format:** Sector outlook with category and project recommendations

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-5

---

## SOURCES & REFERENCES

### Primary Sources
{Protocol docs, on-chain data, official announcements, ecosystem directories}

### Secondary Sources
{Research reports, analytics platforms, industry analyses}

### Tertiary Sources
{News, community discussions}

### Data Providers
{Analytics platforms, market data aggregators}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
