# SECTOR LANDSCAPE

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Sector Landscape (sector-landscape)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Establish comprehensive project database that maps complete market structure and enables systematic project discovery, comparison, and shortlisting. Delivers searchable database covering all active players with consistent evaluation framework - deep analysis on market leaders, general assessment on all others. Enables readers to understand complete landscape, identify quality signals across categories, and build targeted shortlists for investment diligence or product learning.

---

## OBJECTIVES

1. **Map Complete Market Structure** - Build 2-3 complementary dimensions (up to 5 for complex sectors) to classify market from different strategic lenses. Primary dimension defines core market organization with ALL categories identified. Supplementary dimensions reveal additional patterns (market tiers, chain clustering, etc.). For each dimension: define classification basis, identify all categories, establish clear boundaries, assess concentration patterns.

2. **Discover ALL Players** - Conduct comprehensive player discovery per category using multiple sources, ensure complete coverage (ALL active players within scope - both listed and unlisted projects), categorize players accurately, verify player status and activity level (see PLAYER DISCOVERY & SELECTION GUIDANCE in METHODOLOGY)

3. **Deep Dive on Key Players** - Provide detailed profiles on market leaders per category based on multi-signal evaluation, with consistent structure covering identity, positioning, metrics, differentiation, and quality assessment

4. **Assess All Other Players** - For every remaining player in each category, provide compact assessment: description, other dimensions classification, value proposition (1 sentence), native blockchain, stage, investment potential, notable characteristics if any

5. **Assess Investment Potential** - Evaluate RISK:REWARD profile for each player based on multi-signal assessment (quantitative metrics, qualitative indicators, strategic positioning). Provide Investment Potential field in all player profiles with risk/reward levels (Very Low, Low, Medium, High, Very High) or "Undetermined" if insufficient data. Enable readers to build custom shortlists based on their risk appetite and investment thesis.

6. **Deliver Database Format** - Organize output as searchable database (category → all players), maintain consistent evaluation structure across all players, provide summary tables for quick reference, enable easy comparison and filtering

7. **Document Additional Research Findings (Optional)** - Capture significant insights discovered during research that don't fit structured sections (1-4) including unique market dynamics, cross-category effects, emerging patterns, data limitations with clear confidence labeling (HIGH/MEDIUM/LOW). Omit section if no substantial findings emerged beyond standard structure.

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

### MULTI-DIMENSIONAL MARKET STRUCTURE GUIDANCE

**Principle:** Markets are complex - single classification misses critical patterns. Use 2-4 complementary structural dimensions to reveal different strategic insights.

**MANDATORY REQUIREMENT:**
- **Primary dimension** (1): Defines core market organization - how sector naturally segments
- **Supplementary dimensions** (1-2 recommended): Reveal complementary patterns missed by primary lens
  - Standard sectors: 1-2 supplementary (total 2-3 dimensions)
  - Complex sectors: Up to 4 supplementary (total 5 dimensions maximum) if truly necessary
- **Total range:** 2-3 dimensions recommended (up to 5 for highly complex sectors)
- **Guiding principle:** Prioritize depth over breadth - 2-3 well-executed dimensions better than 5 shallow ones

**Common Dimension Types:**
- **Structural:** Layer-Based, Value Chain, Mechanism/Technology
- **Market/Commercial:** Market Position & Scale Tiers, Use Case/Vertical, Business Model
- **Ecosystem/Distribution:** Chain/Ecosystem Clustering, Geographic/Regulatory
- **Maturity/Stage:** Development Stage, Adoption Phase

**For each dimension include:**
1. Dimension name and definition
2. Construction methodology
3. Strategic insight statement
4. Structure visualization
5. Coverage metrics
6. Dimension-specific analysis

### PLAYER DISCOVERY & SELECTION GUIDANCE

**Objective:** Find ALL active players within scope - comprehensive, not selective

**Token status:** Consider both listed and unlisted projects
**Activity threshold:** Adapt to market maturity

**Key Player Selection (Deep Profiles):**
- Players scoring 8-10/10 receive detailed profiling (typically 5-10 per category)
- Players scoring 1-7/10 receive compact profiling

**Selection signals:**
- **Quantitative:** Metrics leadership, funding, growth, revenue, adoption
- **Qualitative:** Team, backing, innovation, first-mover, partnerships, community
- **Strategic:** Infrastructure role, category importance, ecosystem importance, future potential

---

## VALIDATION CRITERIA

- [ ] **Coverage Completeness:** Database demonstrates comprehensive discovery (not selective sampling) - all categories identified with clear boundaries, all active players listed per category with multi-source verification
- [ ] **Database Usability:** Consistent evaluation framework enables systematic comparison - scoring/tiering applied uniformly, key players distinguished from others with clear criteria, investment potential assessed uniformly (RISK:REWARD evaluation provided for all players where data sufficient)
- [ ] **Quality Signals:** Analysis identifies what separates market leaders from followers per category - patterns validated across multiple players, insights grounded in data not speculation
- [ ] **Confidence Labeling:** All findings in Section 5 (Additional Research Findings, if included) tagged with confidence level (HIGH/MEDIUM/LOW) with evidence transparency and source citations

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`

---

*Philosophy: Comprehensive player coverage (ALL active players - listed + unlisted) + systematic categorization (complete market structure) + multi-signal selection (quantitative + qualitative + strategic) + deep profiles on high-scoring (8-10/10) + compact profiles on others (1-7/10) + database format (searchable, comparable, shortlist-ready) + adaptive field structure (sector-specific) → complete market intelligence for investment or product learning*
