<!--
QA REVIEW TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See qa-review/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- QA Verdict: APPROVED / APPROVED WITH REVISIONS / REQUIRES MAJOR REVISION / REJECTED
- Confidence: HIGH / MEDIUM / LOW
- Issue Severity: Critical / High / Medium / Low
- Research Quality: Excellent / Good / Adequate / Needs Work / Poor
- Completeness: Complete / Mostly Complete / Partial / Incomplete
- Accuracy: Verified / Mostly Accurate / Mixed / Questionable
- Bias Level: Minimal / Moderate / Significant / Severe
-->

# QA Review: {Project/Research Name}

**Research reviewed:** {List of research outputs being reviewed}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary of QA findings for decision-making
> **Detail level:** concise
> **Format:** Overall quality rating, critical issues count, key strengths, priority recommendations

---

## 1. COMPLETENESS VALIDATION

> **Purpose:** Verify all required sections completed with appropriate depth
> **Questions:** All sections completed? | Depth matches expectations? | Objectives accomplished? | Critical gaps?
> **Detail level:** standard

### 1.1 Section Coverage

> **What to deliver:** Completeness assessment per section, gaps identified
> **Format:** Section checklist with status (complete/partial/missing), gap descriptions

### 1.2 Depth Assessment

> **What to deliver:** Analysis depth vs stated goals, surface-level vs deep-dive evaluation
> **Format:** Depth rating per major section, overall completeness score

---

## 2. ACCURACY & SOURCE QUALITY

> **Purpose:** Verify claims are accurate and properly sourced
> **Questions:** Claims fact-checked? | Sources attributed? | Data current? | Source credibility?
> **Detail level:** detailed

### 2.1 Source Attribution Audit

> **What to deliver:** Claims without sources, source quality assessment, data currency check
> **Format:** Issue inventory with claim, source status, quality rating

### 2.2 Accuracy Verification

> **What to deliver:** Fact-check results for key claims, inconsistencies found, misattributions
> **Format:** Verified/unverified claims list, accuracy issues with evidence

### 2.3 Uncertainty Communication

> **What to deliver:** Language-confidence alignment check, speculation creep detection
> **Format:** Examples of good/poor uncertainty communication, recommendations

---

## 3. ASSUMPTION CHALLENGES

> **Purpose:** Identify and question unstated assumptions
> **Questions:** What's taken for granted? | Are assumptions reasonable? | Thesis-breaking assumptions?
> **Detail level:** standard

### 3.1 Assumption Inventory

> **What to deliver:** All unstated assumptions identified, validity assessment
> **Format:** Assumption list with evidence quality, reasonableness rating

### 3.2 Critical Assumption Analysis

> **What to deliver:** Assumptions that could invalidate conclusions if wrong
> **Format:** Critical assumptions with impact assessment, validation recommendations

---

## 4. BIAS IDENTIFICATION

> **Purpose:** Detect cognitive biases and distortions in analysis
> **Questions:** Confirmation bias? | Narrative bias? | Groupthink? | Optimism/pessimism bias?
> **Detail level:** standard

### 4.1 Bias Audit

> **What to deliver:** Biases detected across categories, evidence for each
> **Format:** Per bias type: Description, examples from research, severity rating

### 4.2 Balance Assessment

> **What to deliver:** Strengths vs weaknesses coverage balance, perspective fairness
> **Format:** Balance rating, one-sided sections identified, recommendations

---

## 5. LOGICAL CONSISTENCY

> **Purpose:** Evaluate reasoning quality and logical flow
> **Questions:** Arguments support conclusions? | Logical fallacies? | Contradictions? | Non-sequiturs?
> **Detail level:** concise

### 5.1 Logic Assessment

> **What to deliver:** Reasoning quality evaluation, fallacies detected, contradictions found
> **Format:** Logic issues inventory with type, location, severity

---

## 6. STRESS-TEST (DEVIL'S ADVOCATE)

> **Purpose:** Challenge conclusions with opposing arguments
> **Questions:** Strongest counter-thesis? | Thesis breaking points? | Failure modes addressed?
> **Detail level:** standard

### 6.1 Counter-Thesis Development

> **What to deliver:** Steelman opposing argument, thesis vulnerabilities exposed
> **Format:** Counter-thesis summary, breaking points, robustness assessment

### 6.2 Failure Mode Coverage

> **What to deliver:** Failure modes research addresses vs misses
> **Format:** Coverage checklist, blind spots identified

---

## 7. MISSING RISKS & BLIND SPOTS

> **Purpose:** Identify overlooked risks and analysis gaps
> **Questions:** Overlooked risks? | Minimized concerns? | Missing competitive threats? | Unknown unknowns?
> **Detail level:** standard

### 7.1 Risk Coverage Audit

> **What to deliver:** Risk categories assessed, gaps identified, minimized concerns flagged
> **Format:** Risk coverage matrix, missing/understated risks list

---

## 8. FINDINGS PRIORITIZATION

> **Purpose:** Distinguish critical issues from minor ones
> **Questions:** Which issues invalidate analysis? | What must fix vs should fix vs nice to have?
> **Detail level:** detailed

### 8.1 Critical Issues

> **What to deliver:** Issues that must be fixed before use, thesis-invalidating problems
> **Format:** Issue list with description, impact, recommended fix

### 8.2 High Priority Issues

> **What to deliver:** Issues that should be fixed for robustness
> **Format:** Issue list with description, impact, recommended fix

### 8.3 Medium/Low Priority Issues

> **What to deliver:** Improvements that would enhance quality
> **Format:** Issue list with description, priority rating

---

## 9. RECOMMENDATIONS

> **Purpose:** Provide actionable improvements
> **Questions:** How to fix critical issues? | What additional analysis needed? | What strengths to preserve?
> **Detail level:** standard

### 9.1 Must Fix Recommendations

> **What to deliver:** Specific actions for critical issues
> **Format:** Per issue: Specific fix, effort level, priority

### 9.2 Should Consider Recommendations

> **What to deliver:** Improvements for robustness, additional validation suggestions
> **Format:** Recommendation list with rationale, expected impact

### 9.3 Strengths to Preserve

> **What to deliver:** Genuine strengths in analysis to maintain
> **Format:** Strength list with evidence
> **Note:** Balanced critique - acknowledge what works well

---

## QA SUMMARY

> **Purpose:** Overall quality verdict
> **Format:** Quality rating, issue counts by severity, key recommendations, approval status

**Overall Quality:** {rating}
**Critical Issues:** {count}
**High Priority:** {count}
**Medium/Low:** {count}

**Verdict:** {Approved / Approved with Revisions / Requires Major Revision / Rejected}

---

## SOURCES & REFERENCES

### Research Outputs Reviewed
{List of reviewed outputs with dates}

---

**Review completed:** {date}
