# QUALITY ASSURANCE REVIEW

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Quality Assurance Review (qa-review)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Conduct systematic quality assurance review to make research bulletproof through rigorous validation and adversarial thinking. Validate completeness, verify accuracy, challenge assumptions, identify biases, assess logical consistency, stress-test conclusions, identify missing risks, evaluate source quality, distinguish critical from minor issues, and provide constructive recommendations. Enable bulletproof research supporting high-quality decisions.

---

## OBJECTIVES

1. **Validate Research Completeness** - Check all template sections are completed, verify required analysis depth achieved, confirm all stated objectives accomplished, identify critical gaps or missing analysis, flag incomplete or placeholder content

2. **Verify Accuracy & Source Quality** - Fact-check all statistics and quantitative claims, validate source attribution for all claims, assess data currency appropriate for topic volatility, evaluate source credibility, check for data inconsistencies or contradictions

3. **Challenge Key Assumptions** - Identify all unstated assumptions in analysis, question key logical leaps, test assumption validity, expose hidden biases in assumptions, identify assumptions that could invalidate conclusions if wrong

4. **Identify Biases & Cognitive Distortions** - Spot confirmation bias, detect narrative bias, identify groupthink and consensus bias, flag optimism or pessimism bias, detect recency bias, spot anchoring bias, identify survivorship bias, assess whether balanced perspective is maintained

5. **Assess Logical Consistency** - Evaluate reasoning quality, identify logical fallacies, check for contradictions, validate argument structure, test whether conclusions are supported by evidence, verify causal claims are supported

6. **Stress-Test Conclusions (Devil's Advocate)** - Steelman opposing arguments, develop bear case comprehensively, identify thesis breaking points, test robustness of conclusions, challenge optimistic scenarios, examine failure modes

7. **Identify Missing Risks & Blind Spots** - Proactively identify overlooked risks, spot missing failure modes, identify minimized or dismissed concerns, validate competitive threats are comprehensive, identify "unknown unknowns" categories

8. **Evaluate Uncertainty Communication** - Assess language choices appropriately convey confidence, validate sources cited consistently with dates, check uncertainty communicated clearly, identify claims where confidence language mismatches evidence quality

9. **Distinguish Critical vs Minor Issues** - Prioritize findings by decision impact, identify critical flaws that invalidate analysis, flag high-priority issues requiring attention, note medium-priority improvements, provide clear severity classification

10. **Provide Constructive Recommendations** - Offer specific, actionable improvements for each issue, distinguish between "must fix" and "should consider" recommendations, recognize genuine strengths in analysis, prioritize recommendations by impact

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

**Philosophy:** Skeptical mindset (question consensus) + Devil's advocate (steelman opposing arguments) + Detail-oriented (catch inconsistencies) + Risk-focused (emphasize downsides) + Quality-obsessed (zero tolerance for gaps) + Constructive critique (honest but helpful)

---

## VALIDATION CRITERIA

- [ ] All research outputs thoroughly reviewed for completeness and accuracy
- [ ] Assumptions challenged and biases identified systematically
- [ ] Conclusions stress-tested with devil's advocate thinking
- [ ] Critical issues distinguished from minor ones with clear severity classification
- [ ] Constructive recommendations provided (specific and actionable)

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`

---

*Philosophy: Skeptical mindset (question consensus) + Devil's advocate (steelman opposing arguments) + Detail-oriented (catch inconsistencies) + Risk-focused (emphasize downsides) + Quality-obsessed (zero tolerance for gaps) + Constructive critique (honest but helpful)*
