<!--
PROJECT SNAPSHOT TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See project-snapshot/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Project Outlook: BULLISH / NEUTRAL / BEARISH (fundamental view on project quality and potential)
- Confidence: HIGH / MEDIUM / LOW
- Fit Assessment: Strong / Moderate / Weak
- Innovation Level: Breakthrough / Incremental / Standard
- Risk Severity: High / Med / Low
- Stage: Mainnet(Live) / Testnet / Devnet / Funding / Paper
- Moat Strength: Strong / Medium / Weak
- Sustainability: Sustainable / Subsidized / Unclear
-->

# {Project Name} - Project Snapshot

**Topic:** {1 sentence describing the project}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Quick snapshot for investment triage decision
> **Detail level:** concise
> **Format:** Labeled fields covering What, How, Edge, Stage, Risks, Project Outlook

---

## 1. WHAT: PROBLEM-SOLUTION FIT

> **Purpose:** Validate that a real, significant problem exists and this project effectively solves it
> **Questions:** What problem is being solved? | Is it significant and validated? | How does the solution work? | Why blockchain? | How does it compare to alternatives?
> **Detail level:** standard

### 1.1 Problem Being Solved

> **What to deliver:** Problem definition with significance assessment (impact, affected users, validation evidence)
> **Format:** Problem statement with quantified evidence, significance metrics with sources

### 1.2 Solution Approach

> **What to deliver:** How the project solves the problem with performance evidence
> **Format:** Solution explanation, performance data and validation proof with sources

### 1.3 Blockchain Necessity

> **What to deliver:** Justification for why blockchain is needed vs centralized/Web2 alternatives
> **Format:** Specific requirement, Web2 limitation, blockchain value, assessment (Strong/Moderate/Weak)

### 1.4 Alternatives Landscape

> **What to deliver:** Comparison of this solution vs existing Web2 and crypto alternatives
> **Format:** Comparison table with approach and limitations, fit assessment

---

## 2. HOW: CORE MECHANICS

> **Purpose:** Explain system architecture, mechanisms, innovation level, security, and business model
> **Questions:** What's the system architecture? | How do core mechanisms work? | What's the innovation level? | Is it secure and performant? | Does the business model work?
> **Detail level:** standard

### 2.1 Architecture

> **What to deliver:** System stage, platform choice with rationale, simplified architecture diagram
> **Format:** Stage/platform/rationale, system diagram (ASCII or description)

### 2.2 Core Mechanisms

> **What to deliver:** Primary (and secondary if applicable) mechanism workflows with dependencies
> **Format:** Numbered workflow steps, dependencies with risk assessment

### 2.3 Technical Approach

> **What to deliver:** Innovation assessment with novel elements, standard parts, and trade-offs
> **Format:** Innovation level, novel elements with advantage and replicability, trade-offs with mitigation

### 2.4 Security & Performance

> **What to deliver:** Security status (audits, findings, incidents) and performance metrics
> **Format:** Audit details with dates, findings status, incident history, throughput and cost metrics

### 2.5 Business Model

> **What to deliver:** Revenue model and sustainability assessment
> **Format:** Revenue source/current/growth with sources, sustainability status (Sustainable/Subsidized/Unclear)

---

## 3. DIFFERENTIATION: COMPETITIVE ADVANTAGES

> **Purpose:** Assess value proposition, competitive differentiation, and defensibility
> **Questions:** What's the primary value delivered? | How does it compare to competitors? | What are unique advantages? | How defensible are the moats?
> **Detail level:** standard

### 3.1 Value Proposition

> **What to deliver:** Primary value delivered with validation evidence
> **Format:** Primary value statement, validation (delivers yes/no + evidence, user feedback)

### 3.2 Competitive Differentiation

> **What to deliver:** Comparison matrix vs competitors with unique advantages
> **Format:** Comparison table (4-6 metrics most relevant to differentiate), unique advantages with defensibility and evidence
> **Note:** Choose metrics based on what matters for this project type

### 3.3 Defensibility

> **What to deliver:** Primary moats assessment and fork risk analysis
> **Format:** 3 moat types with strength assessment, fork risk (code/network/overall)

---

## 4. RED FLAGS & RISKS

> **Purpose:** Proactively identify critical risks across all dimensions
> **Questions:** What are the technical risks? | What are the market/product risks? | What are the execution risks? | What are the competitive threats?
> **Detail level:** standard

### 4.1 Critical Risks

> **What to deliver:** Critical risks across Technical, Market/Product, Execution, Competitive dimensions
> **Format:** Four risk categories, each with 0-3 risks showing issue, severity (High/Med/Low), and mitigation/impact/timeline

---

## 5. PROJECT OUTLOOK

> **Purpose:** Synthesize project analysis into outlook assessment
> **Questions:** What's the project outlook? | What are key reasons? | What to monitor?
> **Detail level:** concise

> **What to deliver:**
> - **Project Outlook:** BULLISH / NEUTRAL / BEARISH (fundamental view on project quality and potential)
>   - BULLISH: Strong problem-solution fit, solid mechanics, defensible advantages, manageable risks
>   - NEUTRAL: Adequate fundamentals with mixed signals, moderate differentiation, conditional potential
>   - BEARISH: Weak fit, flawed mechanics, limited advantages, significant risks
> - **Rationale:** 3-5 key reasons with evidence from analysis above
> - **Key Catalysts:** Events or milestones that could shift the outlook
> - **Monitoring Priorities:** Key metrics to track, warning signals
> **Format:** Project outlook rating with supporting rationale and monitoring framework
> **Note:** This is a holistic project view; for deeper analysis, use dimension-specific workflows

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-5

---

## SOURCES & REFERENCES

### Primary Sources
{Protocol documentation, on-chain data, whitepapers, audit reports}

### Secondary Sources
{Research reports, analytics platforms, industry analyses}

### Tertiary Sources
{News, community discussions}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
