# PROJECT SNAPSHOT

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Project Snapshot (project-snapshot)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Generate quick but thorough project snapshot that answers 3 core questions: (1) What problem is being solved and how (problem-solution fit), (2) How does the protocol work at its core (mechanics & technical approach), (3) What makes it different from alternatives (competitive differentiation). Enable rapid project understanding for initial assessment, go/no-go decisions, or executive briefings through evidence-backed analysis delivered in concise format.

---

## OBJECTIVES

1. **Validate WHAT: Problem-Solution Fit** - Identify the problem being solved (is it real? significant?), understand the solution approach (how does it address the problem?), assess problem-solution fit quality (validated with user testimonials, adoption data), justify why blockchain is needed (vs Web2 alternatives), evaluate value proposition and user economics (who benefits? how much?), and compare to existing solutions (Web2, crypto competitors)

2. **Understand HOW: Core Mechanics** - Explain how the protocol works at its core (architecture, key mechanisms, workflow), identify technical approach and platform choice (which chain, why, trade-offs), assess innovation level (breakthrough vs standard implementation), evaluate implementation quality (security audits, performance, incidents), validate implementation status (live/testnet/paper), identify critical dependencies (oracles, infrastructure, other protocols), and assess business model sustainability (revenue model, economics)

3. **Identify DIFFERENTIATION: Competitive Advantages** - Define unique value proposition (what benefit does this provide?), identify competitive differentiators (what can only this protocol do? how hard to replicate?), evaluate defensibility (moats, barriers to entry, time-to-replicate), compare to direct alternatives (feature/metric comparison matrix), and assess competitive positioning (where does this fit in landscape?)

4. **Surface RED FLAGS & RISKS** - Proactively identify critical red flags across all dimensions (technical risks: security, dependencies, centralization; market/product risks: PMF validation gaps, adoption concerns; execution risks: timeline delays, team capability, delivery track record; competitive threats: replication risk, market timing), assess severity and probability, identify deal-breakers (issues that would prevent investment/usage), and provide balanced perspective (strengths AND weaknesses)

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

---

## VALIDATION CRITERIA

- [ ] 3 core questions answered clearly: What (problem-solution), How (mechanics), Differentiation (advantages)
- [ ] Multi-source validation (2+ sources for key claims)
- [ ] Red flags identified proactively (not ignored)
- [ ] Concise format maintained (signal over noise, no unnecessary detail)

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
