<!--
PRODUCT ANALYSIS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See product-analysis/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Product Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from product perspective)
- Confidence: HIGH / MEDIUM / LOW
- Fit/Effectiveness: Strong / Moderate / Weak
- Innovation Score: Breakthrough (9-10) / Significant (7-8) / Incremental (4-6) / Standard (1-3)
- Moat Strength: Strong / Moderate / Weak
- Risk Severity: High / Med / Low
- Stage: Mainnet(Live) / Testnet / Devnet / Funding / Paper
- Position: Leader / Challenger / Nicher / Emerging
-->

# {Project Name} - Product Analysis

**Topic:** {1 sentence describing the protocol/product}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary of critical findings for quick decision-making
> **Detail level:** concise
> **Format:** Labeled fields covering What, Moat, PMF Signals, Innovation, Red Flags, Product Implications

---

## 1. PROBLEM-SOLUTION FIT

> **Purpose:** Validate that a real problem exists and this protocol effectively solves it
> **Questions:** Is the problem significant? | Does the solution actually work? | Is this better than alternatives? | How well does it deliver value?
> **Detail level:** detailed

### 1.1 Problem Validation

> **What to deliver:** Problem statement, analysis (severity/frequency/scale/cost/urgency), stakeholder pain points, validation evidence, assessment
> **Format:** Structured analysis with quantified metrics. Multi-source validation required

### 1.2 Solution Approach

> **What to deliver:** Core solution explanation, mechanism breakdown (what/how/trade-offs), approach justification (why this vs alternatives)
> **Format:** Structure that best explains causality (narrative, diagrams, or tables)

### 1.3 Value Proposition & Stakeholder Engagement

> **What to deliver:** Core value delivered (with metrics), stakeholder segments (size/needs/fit), engagement & value exchange flows
> **Format:** Evidence-based presentation showing value actually delivered, not just promised

### 1.4 Solution Effectiveness

> **What to deliver:** Comparative analysis vs alternatives (3-6 dimensions), unique advantages, solution gaps
> **Format:** Table/matrix for multiple alternatives, narrative for few. Cite metrics with sources

---

## 2. PROTOCOL MECHANICS & INNOVATION

> **Purpose:** Explain how the protocol works technically and assess innovation level
> **Questions:** What is this system? | How does it work? | What's novel? | What are the risks?
> **Detail level:** detailed

### 2.1 System Architecture

> **What to deliver:** System overview (type, stage, deployment), architecture (components and relationships), design decisions (key choices with rationale), critical components deep-dive (3-6 most critical)
> **Format:** Diagram/narrative/table depending on complexity. Focus on components critical to value delivery or risk

### 2.2 Core Mechanisms

> **What to deliver:** 1-3 most important mechanisms with Purpose, Technical workflow (triggers/actors/steps/outputs/failure handling), Parameters (values/governance/risks), Mechanism analysis
> **Format:** Structure that best explains causality. Analysis type depends on mechanism nature (economic, technical, consensus)

### 2.3 Technical Innovation

> **What to deliver:** Innovation classification (types present), breakthrough elements (if genuine - novel/advancement/defensibility), standard implementations, innovation score with rationale
> **Format:** Honest assessment - many successful protocols have zero breakthrough innovations
> **Note:** Defensibility matters more than novelty for investment

### 2.4 Design Trade-offs

> **What to deliver:** 3-5 most impactful trade-offs with dimension traded, choice made, rationale, gains/sacrifices, mitigation
> **Format:** Structured entries explaining why each choice is right for this context

### 2.5 Implementation Quality

> **What to deliver:** Code quality, security assessment (audits/bounty/incidents), performance metrics (benchmarked vs competitors), scalability analysis
> **Format:** Tables for multi-metric comparison. Benchmark against competitors and standards

### 2.6 Technical Risks & Dependencies

> **What to deliver:** Critical dependencies (3-6 with type/function/failure scenario/mitigation), technical risk assessment by category, black swan scenarios
> **Format:** Risk matrix for multiple risks. Focus on material risks impacting protocol function or user funds

---

## 3. ECONOMICS & BUSINESS MODEL

> **Purpose:** Assess protocol economics and business model sustainability
> **Questions:** How does protocol generate revenue? | Who captures value? | Is the economic model sustainable?
> **Detail level:** standard

### 3.1 Revenue Model

> **What to deliver:** Revenue sources (breakdown with %), fee structure and economics, current revenue and trends, path to profitability/sustainability
> **Format:** Structured analysis with metrics and timeframes

### 3.2 Economic Security

> **What to deliver:** Security metrics (TVL/Mcap, Revenue/Emissions, POL vs rented liquidity), economic vulnerabilities (ponzinomics, death spiral, mercenary capital risks)
> **Format:** Metrics with interpretation, vulnerability assessment

### 3.3 Value Capture Mechanism

> **What to deliver:** Who captures value (by stakeholder), capture mechanisms (fees/token economics/governance/yield), alignment & sustainability assessment
> **Format:** Structured analysis by stakeholder type

---

## 4. PRODUCT-MARKET FIT SIGNALS

> **Purpose:** High-level PMF assessment to validate product quality through adoption signals
> **Questions:** What are the headline retention signals? | Is growth organic or incentive-driven? | What's the current PMF stage?
> **Detail level:** concise

### 4.1 PMF Assessment

> **What to deliver:** Retention signal (30d/90d headline rates with benchmark), growth quality signal (organic vs incentivized), current PMF stage (Strong/Emerging/Weak with rationale)
> **Format:** Summary indicators only - NOT detailed traction analysis. Reference traction-metrics workflow for comprehensive analysis
> **Note:** For pre-launch/<3mo/testnet, state available signals and data limitations clearly

---

## 5. COMPETITIVE POSITIONING

> **Purpose:** Map competitive landscape and assess differentiation
> **Questions:** Who are the competitors? | What makes this different? | How strong is the moat?
> **Detail level:** standard

### 5.1 Competitive Landscape

> **What to deliver:** Market definition (category/size/growth), competitive set (direct/indirect/adjacent/disruptors), market share (this protocol vs competitors with trends)
> **Format:** Structured analysis with relevant metrics (TVL/users/volume)

### 5.2 Differentiation Analysis

> **What to deliver:** Differentiation matrix (5-8 dimensions most relevant for THIS market), unique differentiators (with defensibility), crypto-native evaluation (4-6 relevant dimensions)
> **Format:** Comparison table benchmarking vs 3-5 competitors. Choose dimensions that matter for differentiation in this specific market

### 5.3 Strategic Positioning

> **What to deliver:** Position & strategy (current position, competitive strategy), industry forces (5 forces with attractiveness), competitive advantages (3-5 with sustainability), competitive disadvantages (honest gaps with mitigation)
> **Format:** Structured assessment with conclusion on competitive position strength

---

## 6. RED FLAGS & RISKS

> **Purpose:** Proactively identify all critical risks for complete picture
> **Questions:** What are material risks across all dimensions? | What are the major risks by probability and impact? | What are the failure scenarios?
> **Detail level:** standard

### 6.1 Risk Assessment by Category

> **What to deliver:** Material risks across technical, product, adoption, economic, execution dimensions
> **Format:** Categorized lists or risk matrix. For each risk: issue, severity, impact, mitigation
> **Note:** Economic risks especially important: ponzinomics, death spirals, unsustainable yields, mercenary capital

### 6.2 Risk Prioritization

> **What to deliver:** Major risks with probability (H/M/L), impact (H/M/L), severity, mitigation strategy, timeline
> **Format:** Risk matrix recommended. Consider correlated risk scenarios

### 6.3 Bear Case Analysis

> **What to deliver:** Failure scenarios (2-4 with probability/impact), devil's advocate questions (why might this fail), survival assessment (probability distribution with rationale)
> **Format:** Structured downside analysis

---

## 7. INVESTMENT IMPLICATIONS

> **Purpose:** Synthesize product analysis into investment implications
> **Questions:** What are the product implications for investment? | What are key reasons? | What to monitor?
> **Detail level:** concise

> **What to deliver:**
> - **Product Implications:** POSITIVE / NEUTRAL / NEGATIVE (from product perspective)
>   - POSITIVE: Strong problem-solution fit, defensible moats, clear PMF signals, sustainable economics
>   - NEUTRAL: Adequate product with mixed signals, moderate differentiation, conditional sustainability
>   - NEGATIVE: Weak fit, limited moats, poor PMF signals, unsustainable economics
> - **Rationale:** 3-5 key reasons with evidence from analysis above
> - **Key Catalysts:** Near/medium/long-term with dates and impact
> - **Monitoring Priorities:** Key metrics to track, warning signals
> **Format:** Product implications rating with supporting rationale and monitoring framework
> **Note:** This is product-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-7

---

## SOURCES & REFERENCES

### Primary Sources
{Protocol documentation, on-chain data, whitepapers, code repositories, audit reports}

### Secondary Sources
{Research reports, analytics platforms, industry analyses}

### Tertiary Sources
{News, community discussions}

### Data Providers
{On-chain analytics, market data aggregators}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
