# PRODUCT/PROTOCOL ANALYSIS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Product/Protocol Analysis (product-analysis)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Conduct comprehensive product/protocol analysis to understand what the project builds, how it works, whether it solves a real problem, and if the economics are sustainable. Validate problem-solution fit and value proposition with evidence, evaluate protocol mechanics and innovation with technical depth, assess economics and business model sustainability, measure product-market fit through summary retention signals, analyze competitive positioning and differentiation, and surface red flags across all dimensions. Enable informed decisions about product quality and investment viability.

---

## OBJECTIVES

1. **Validate Problem-Solution Fit & Value Proposition** - Identify the problem being solved (is it real? well-defined? significant?), assess solution approach (does it actually solve the problem? why blockchain?), validate with evidence (stakeholder testimonials, adoption data, problem quantification), define core value proposition (what value is delivered?), analyze stakeholder segments (who benefits? how large is addressable market?), evaluate value delivery (does it actually deliver promised value vs claims?), and compare to alternatives (Web2, competing crypto solutions)

2. **Evaluate Protocol Mechanics & Innovation** - Deep dive into how the protocol works (architecture, key mechanisms, workflow), assess technical innovation (what's novel? what's standard? breakthrough vs incremental?), analyze design trade-offs (security vs efficiency, decentralization vs UX, scalability vs simplicity), validate implementation quality (code audits, architecture review, on-chain behavior), evaluate defensibility (how hard to replicate? moats? time-to-replicate?), and identify technical risks (vulnerabilities, dependencies, scalability limits)

3. **Assess Economics & Business Model** - Analyze revenue model (how does protocol generate revenue? sustainability?), evaluate value capture mechanisms (who captures value? token holders? protocol? users?), assess economic security (attack cost vs economic value, MEV risks), identify economic risks (death spiral scenarios, mercenary capital dependency, ponzinomics patterns), and validate business model sustainability (can economics support long-term operations?)

4. **Measure Product-Market Fit Signals (Summary)** - Assess high-level PMF indicators (30d/90d retention rates, organic vs incentivized growth signals, engagement trends), benchmark against category averages, identify critical adoption barriers, and cross-reference to traction-metrics workflow for detailed cohort analysis, unit economics, and growth channel breakdown

5. **Evaluate Competitive Positioning** - Identify direct and indirect competitors, define unique differentiators (what can only this protocol do?), assess competitive advantages with evidence (feature comparison, performance benchmarks, market positioning), evaluate defensibility and moats, analyze competitive threats (replication risk, market timing), and determine where protocol fits in landscape

6. **Surface Red Flags & Risks** - Proactively identify technical red flags (architecture flaws, security risks, scalability issues, centralization points), spot product red flags (value proposition unclear, weak PMF signals, copied features), detect economic red flags (unsustainable yields, ponzinomics, value capture issues), identify execution risks (roadmap delays, team capability gaps, resource constraints), and assess downside scenarios with probability-weighted impact

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

---

## VALIDATION CRITERIA

- [ ] Problem-solution fit validated with evidence (not just marketing claims)
- [ ] Value proposition analyzed with stakeholder segments and value delivery assessment
- [ ] Protocol mechanics explained with technical depth and innovation level assessed
- [ ] Economics & business model sustainability validated (revenue model, value capture, economic risks)
- [ ] PMF signals assessed at summary level
- [ ] Competitive positioning established with evidence-backed differentiation
- [ ] Red flags and risks proactively identified across all dimensions (technical, product, economic, execution)

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
