# OPEN RESEARCH

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Open Research (open-research)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Deliver high-quality research on any topic defined by the user. Understand user intent deeply before execution, apply appropriate research methodology, and produce actionable insights structured around the user's specific questions. Maintain research rigor regardless of topic flexibility.

---

## OBJECTIVES

1. **Clarify Intent** - Thoroughly understand the research question, user's decision context, prior knowledge, scope boundaries, and output expectations before execution

2. **Execute Research** - Apply appropriate methodology for question type, gather evidence from multiple sources, maintain research rigor through source verification and confidence scoring

3. **Deliver Answer** - Present findings in clear structure that directly answers the research question, with actionable insights aligned to user's decision context

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

**Open Research Principles:**
- Methodology adapts to question type (not fixed)
- Structure emerges from findings (not predetermined)
- Rigor maintained through process (source verification, confidence scoring)
- User intent guides prioritization

**Scope Clarification Requirements (Default: FULL PATH):**

1. **Research Question** - Primary research question? Sub-questions (if any)?

2. **Intent & Decision Context** - Why is this research needed? What decision will it inform? Time sensitivity?

3. **Prior Context & References** - What does user already know? Any existing research/documents? Any URLs/links to reference?

4. **Scope Boundaries** - What to include? What to explicitly exclude?

5. **Output Requirements** - Depth (brief | standard | comprehensive), Audience, Rigor level, Need actionable recommendations?

**Scope Summary Format:**
```
Here's my understanding of your request:

- **Research Question:** {extracted/inferred}
- **Intent:** {inferred from context} ← confirm?
- **Prior Knowledge:** {what user seems to know} ← correct?
- **Scope:** {proposed boundaries} ← confirm?
- **Excludes:** {proposed exclusions} ← ok?
- **Depth:** {brief | standard | comprehensive} ← select?
- **Output focus:** {proposed focus areas} ← confirm?

Anything that needs adjustment?
```

---

## VALIDATION CRITERIA

- [ ] Research question directly answered
- [ ] All claims supported by cited sources
- [ ] Confidence level stated for key conclusions
- [ ] Scope boundaries respected (no scope creep)

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`

---

*Philosophy: Research rigor without structural rigidity. Understand deeply, execute flexibly, deliver precisely.*
