<!--
SECTOR RESEARCH BRIEF TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See create-research-brief/objectives.md
- Usage: Fill all sections, replace [placeholders] with actual content

PURPOSE: Define scope for sector/market/ecosystem analysis
OUTPUT: Sector Outlook with allocation priorities or product focus recommendations

SCALES (use consistently):
- Sector Outlook: BULLISH / NEUTRAL / BEARISH (fundamental view on sector potential)

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

BRIEF SECTION FORMAT:
> **Purpose:** What this section captures
> **Fill in:** Guidance for user input
-->

# Research Brief: [Sector/Ecosystem Name]

**Research Type:** Sector Research
**Date:** {date}

---

## 1. CONTEXT

> **Purpose:** Establish decision context and current position
> **Fill in:** Specific allocation or product decision needed

**Decision to Make:**
[e.g., "Allocate 15-20% to DeFi Lending - which sub-segments?" or "Build product in DeFAI - where's the opportunity?"]

**Current Position:**
[e.g., "No DeFi Lending exposure" or "Exploring AI x Crypto product opportunity"]

---

## 2. RESEARCH PURPOSE

> **Purpose:** Define success criteria for research completion
> **Fill in:** Primary goal and measurable completion criteria

**Primary Goal (1-2 sentences):**
[e.g., "Understand DeFi Lending structure, identify highest-potential sub-segments for allocation"]

**Research is Complete When:**
- Sector Outlook: BULLISH / NEUTRAL / BEARISH with supporting rationale
- Clear sector definition and taxonomy
- Market sizing validated (TAM/SAM)
- Major players mapped (top 10+)
- Competitive dynamics understood
- Highest-potential sub-segments identified
- Clear recommendations (allocation OR product focus)

---

## 3. RESEARCH SUBJECT

> **Purpose:** Identify what to study with classification
> **Fill in:** Subject details and background context

**Subject:** [Sector/Ecosystem name]

**Category:** [DeFi Primitive | Infrastructure Layer | Application Sector | Thematic Trend]

**Background (1-2 sentences):**
[Brief description of sector and current state]

---

## 4. RESEARCH SCOPE

> **Purpose:** Define boundaries - what's in, what's out, what to prioritize
> **Fill in:** Focus areas with rationale, explicit inclusions/exclusions

### 4.1 Priority Focus Areas

> **Fill in:** 3-5 areas critical to sector understanding

1. **[Focus Area]** - [brief context if needed]
2. **[Focus Area]** - [brief context if needed]
3. **[Focus Area]** - [brief context if needed]
4. **[Focus Area]** - [brief context if needed]
5. **[Focus Area]** - [optional]

### 4.2 In Scope

> **Fill in:** Explicit inclusions for sector analysis

- Sector definition and taxonomy (sub-segments)
- Market sizing: TAM/SAM, growth trajectory
- Major players mapping: top 10-15 with positioning
- Competitive dynamics: concentration, differentiation, moats
- Growth drivers and trends: catalysts, innovation, headwinds
- Risk assessment: sector-level risks
- Regulatory landscape: sector-level regulatory trends and risks
- Coverage: [chain scope, TVL threshold, etc.]
- Time horizon: [historical period, forward outlook]
- Analysis balance: 60-70% understanding, 30-40% recommendations
- [Add specific inclusions]

### 4.3 Out of Scope

> **Fill in:** Explicit exclusions to prevent scope creep

- Deep project-level analysis (use project-research for individual projects)
- Technical architecture deep-dives per project
- Full investment thesis per project (use investment-research)
- Historical analysis beyond [specified timeframe]
- [Add specific exclusions]

---

**Brief created:** {date}
