<!--
PROJECT RESEARCH BRIEF TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See create-research-brief/objectives.md
- Usage: Fill all sections, replace [placeholders] with actual content

PURPOSE: Define scope for focused project analysis (NOT investment)
OUTPUT: Project assessment recommendation

SCALES (use consistently):
- Project Recommendation: DEEP DIVE / MONITOR / PASS

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

BRIEF SECTION FORMAT:
> **Purpose:** What this section captures
> **Fill in:** Guidance for user input
-->

# Research Brief: [Project/Protocol Name]

**Research Type:** Project Research (Focused)
**Date:** {date}

---

## 1. CONTEXT

> **Purpose:** Establish decision context and current position
> **Fill in:** Specific decision needed (project understanding, competitive intel, technical evaluation)

**Decision to Make:**
[e.g., "Evaluate Hyperliquid's traction and differentiation" or "Assess Uniswap V4 architecture for competitive analysis"]

**Current Position:**
[e.g., "Exploring project for deeper research" or "Evaluating competitive landscape"]

---

## 2. RESEARCH PURPOSE

> **Purpose:** Define success criteria for research completion
> **Fill in:** Primary goal and measurable completion criteria

**Primary Goal (1-2 sentences):**
[e.g., "Understand Hyperliquid's differentiation and traction for competitive analysis"]

**Research is Complete When:**
- Clear product value prop and PMF validation
- Traction quality quantified (organic %, DAU/MAU)
- Competitive positioning vs alternatives
- Clear recommendation (DEEP DIVE/MONITOR/PASS)

---

## 3. RESEARCH SUBJECT

> **Purpose:** Identify what to study with classification
> **Fill in:** Subject details and background context

**Subject:** [Project/Protocol name]

**Category:** [DeFi | L1-L2 Infrastructure | Application Layer | etc.]

**Stage:** [Mainnet | Testnet | Development | Pre-launch]

**Background (1-2 sentences):**
[Brief description of what project does and current status]

**Official Links:**
- Website: [URL]
- Documentation: [URL]
- X (Twitter): [URL]
- GitHub: [URL if applicable]

---

## 4. RESEARCH SCOPE

> **Purpose:** Define boundaries - what's in, what's out, what to prioritize
> **Fill in:** Focus areas with rationale, explicit inclusions/exclusions

### 4.1 Priority Focus Areas

> **Fill in:** 3-5 areas critical to project assessment

1. **[Focus Area]** - [brief context if needed]
2. **[Focus Area]** - [brief context if needed]
3. **[Focus Area]** - [brief context if needed]
4. **[Focus Area]** - [brief context if needed]
5. **[Focus Area]** - [optional]

### 4.2 In Scope

> **Fill in:** Explicit inclusions for project analysis

- Product deep-dive: value prop, UX, differentiation
- PMF validation: retention, organic growth signals
- Traction analysis: users, revenue/TVL, engagement
- Competitive positioning vs top 3-5 competitors
- Team capability (light): founders, execution track record
- Technical overview: architecture, security (if relevant)
- Comparison scope: [specific competitors]
- Time horizon: [historical period, roadmap horizon]
- [Add specific inclusions]

### 4.3 Out of Scope

> **Fill in:** Explicit exclusions to prevent scope creep

- Full market/sector analysis (use sector-research first)
- Investment thesis with BUY/SELL recommendation (use investment-research)
- Deep tokenomics modeling (use tokenomics-analysis workflow)
- Full smart contract audit (requires security auditor)
- [Add specific exclusions]

---

**Brief created:** {date}
