<!--
INVESTMENT RESEARCH BRIEF TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See create-research-brief/objectives.md
- Usage: Fill all sections, replace [placeholders] with actual content

PURPOSE: Define scope for comprehensive investment analysis
OUTPUT: 3-dimensional assessment (Outlook + Valuation + Decision) with position sizing

SCALES (use consistently):
- Investment Outlook: BULLISH / NEUTRAL / BEARISH (fundamental view)
- Valuation: UNDERVALUED / FAIR VALUE / OVERVALUED (price assessment)
- Investment Decision: STRONG BUY / BUY / WATCH / SELL / STRONG SELL

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

BRIEF SECTION FORMAT:
> **Purpose:** What this section captures
> **Fill in:** Guidance for user input
-->

# Research Brief: [Project/Protocol Name] - Investment Analysis

**Research Type:** Investment Research (Comprehensive)
**Date:** {date}

---

## 1. CONTEXT

> **Purpose:** Establish decision context and current position
> **Fill in:** Specific decision needed, existing exposure, portfolio considerations

**Decision to Make:**
[e.g., "Should we invest in Uniswap V4? What position size appropriate?"]

**Current Position:**
[e.g., "No exposure to DEX sector currently"]

**Portfolio Context:**
- Current exposure: [sector exposure as % of portfolio]
- Diversification goal: [allocation strategy]
- Correlation (optional): [overlap with existing holdings]

---

## 2. RESEARCH PURPOSE

> **Purpose:** Define success criteria for research completion
> **Fill in:** Primary goal and measurable completion criteria

**Primary Goal (1-2 sentences):**
[e.g., "Determine investment attractiveness of Uniswap V4 with BUY/PASS recommendation and position sizing"]

**Research is Complete When:**
- 3-dimensional assessment: Outlook + Valuation + Decision (STRONG BUY/BUY/WATCH/SELL/STRONG SELL)
- Conviction level (HIGH/MEDIUM/LOW) with supporting rationale
- Position sizing guidance based on risk-adjusted analysis
- Bull/base/bear scenarios with valuation ranges
- Entry/exit criteria and monitoring framework

---

## 3. RESEARCH SUBJECT

> **Purpose:** Identify what to study with classification
> **Fill in:** Subject details and background context

**Subject:** [Project/Protocol name]

**Category:** [DeFi | L1-L2 Infrastructure | Application Layer | DePIN | etc.]

**Stage:** [Mainnet | Testnet | Development | Pre-launch]

**Background (1-2 sentences):**
[Brief description of what project does and current status]

**Official Links:**
- Website: [URL]
- Documentation: [URL]
- X (Twitter): [URL]
- GitHub: [URL if applicable]

---

## 4. RESEARCH SCOPE

> **Purpose:** Define boundaries - what's in, what's out, what to prioritize
> **Fill in:** Focus areas with rationale, explicit inclusions/exclusions

### 4.1 Priority Focus Areas

> **Fill in:** 3-5 areas critical to investment decision

1. **[Focus Area]** - [brief context if needed]
2. **[Focus Area]** - [brief context if needed]
3. **[Focus Area]** - [brief context if needed]
4. **[Focus Area]** - [brief context if needed]
5. **[Focus Area]** - [optional]

### 4.2 In Scope

> **Fill in:** Explicit inclusions for investment analysis

- Market context: TAM/SAM/SOM, growth drivers, sector positioning
- Sector landscape: competitive analysis, major competitors
- Project fundamentals: product/PMF, team, tokenomics, traction
- Technical evaluation: architecture, security assessment
- Legal & Regulatory: jurisdiction, compliance approach, regulatory risk
- Investment thesis: bull/base/bear scenarios with valuation
- Position sizing and entry/exit criteria
- Comparison scope: [specific competitors to compare]
- Time horizon: [historical period, investment horizon]
- [Add specific inclusions]

### 4.3 Out of Scope

> **Fill in:** Explicit exclusions to prevent scope creep

- Formal legal opinion (requires licensed attorney)
- Line-by-line smart contract audit (requires security auditor)
- Macro market timing predictions
- Guaranteed returns or specific price targets
- [Add specific exclusions]

---

**Brief created:** {date}
