# CONTENT CREATION

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Content Creation (create-content)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Transform crypto research into platform-optimized content that amplifies distribution reach and drives audience engagement. Deliver content tailored to audience knowledge level, maintaining research accuracy while achieving format-specific engagement objectives. Adapt narrative and format to platform requirements while preserving core message integrity.

---

## OBJECTIVES

1. **Define Narrative Strategy** - Identify core message from research, determine narrative angle, understand target audience, extract key takeaways, and design narrative flow that delivers value progressively

2. **Create Platform-Optimized Content** - Transform research into selected format(s) following platform-specific best practices for structure, pacing, and engagement patterns. Adapt narrative, length, and tone to maximize platform effectiveness while preserving research integrity.

3. **Maintain Research Integrity** - Ground all claims in source research, preserve nuance when condensing, distinguish facts from analysis, include appropriate attribution

4. **Optimize for Engagement** - Craft format-appropriate hooks, structure for retention and completion, include strategic calls-to-action, suggest media elements where applicable

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{content-style}`

**Content Direction Establishment (MANDATORY before execution):**

1. **Core Message:** What's the ONE thing audience must understand?
2. **Target Audience:** Who, knowledge level, what they need?
3. **Narrative Angle:** Educational / Contrarian / Analysis / Story?
4. **Value Promise:** What specific value will audience gain?

Present content direction summary to user and wait for confirmation before proceeding.

---

## VALIDATION CRITERIA

- [ ] Core message clear and memorable (can state in one sentence)
- [ ] Hook captures attention in first moment (testable: would stop scroll/reading?)
- [ ] All claims traceable to source research (research integrity maintained)
- [ ] Platform-optimized (meets platform constraints: character limits, duration, structure)
- [ ] Engagement mechanics embedded (appropriate hooks, CTAs, value delivery for format)

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
