<!--
COMPETITIVE ANALYSIS TEMPLATE
INSTRUCTIONS:
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)
- Validation: See competitive-analysis/objectives.md

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SCALES (use consistently):
- Confidence: HIGH / MEDIUM / LOW
- Score: 1-10
- Moat Strength: Strong / Moderate / Weak
- Risk Level: High / Med / Low
- Stage: Mainnet(Live) / Testnet / Devnet / Funding / Paper
- Defensibility: Strong / Moderate / Weak
- Effectiveness: High / Medium / Low

COMPETITIVE IMPLICATIONS (per project):
- Competitive Implications: POSITIVE / NEUTRAL / NEGATIVE (investment implication from competitive perspective)

COMPARISON PURPOSES:
- Investment Comparison: Competitive implications per project with ranking
- Product Positioning: Strategy with white space opportunities
- Category Understanding: Insights with market patterns
-->

# {Projects} - Competitive Analysis

**Topic:** {1 sentence describing the comparison}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick decision-making on comparison purpose
> **Detail level:** concise
> **Format:** Labeled fields covering comparison purpose, projects compared, recommendation, key differentiators, ranking summary, strategic implications

---

## 1. PROJECT PROFILES

> **Purpose:** Comprehensive profile of each project for fair comparison
> **Questions:** What is each project's core value proposition? | What are strengths and weaknesses? | How defensible are competitive moats? | What's the bear case?
> **Detail level:** detailed

### Project A: [Name]

> **What to deliver:** Complete project profile covering Overview (stage, category, team, funding, metrics), SWOT Analysis (3-5 per quadrant with evidence), Competitive Moats (6 dimensions with sustainability), Evaluation Matrix (8 criteria scored 1-10), Bear Case Analysis (failure scenarios with probability)
> **Format:** Five substructures with standardized fields. Provide quantitative evidence for all claims
> **Note:** Maintain equal depth across all projects - no favoritism

### Project B-N: [Names]

> **What to deliver:** Same structure as Project A for each additional project
> **Format:** Five substructures - maintain equal depth

---

## 2. HEAD-TO-HEAD BENCHMARKING

> **Purpose:** Direct comparison tables identifying leaders and gaps
> **Questions:** Who leads on key metrics? | What's the performance gap? | Who has best features? | Who has strongest team and backing?
> **Detail level:** detailed

### 2.1 Metrics Comparison

> **What to deliver:** Side-by-side metrics comparison showing market performance and financial/valuation metrics
> **Format:** Comparison tables with Leader and Gap columns, followed by key insights

### 2.2 Feature Comparison Matrix

> **What to deliver:** Feature-by-feature comparison identifying best-in-class
> **Format:** Comparison table with feature gap analysis

### 2.3 Technical Comparison

> **What to deliver:** Architecture, performance, and security comparison
> **Format:** Comparison tables with technical winner assessment

### 2.4 Team & Backing Comparison

> **What to deliver:** Founding team and funding/investor comparison
> **Format:** Comparison tables with team winner assessment

---

## 3. COMPARATIVE POSITIONING

> **Purpose:** Visualize and analyze strategic positioning to identify competitive dynamics and white space
> **Questions:** How do projects position differently? | Where are white space opportunities? | How defensible is each differentiation?
> **Detail level:** standard

### 3.1 Positioning Map

> **What to deliver:** 2×2 positioning map visualization with positioning analysis per project and white space opportunities
> **Format:** ASCII positioning map, structured analysis per project (Positioning, Strengths, Weaknesses, Effectiveness), white space and strategic insights
> **Note:** Choose dimensions most relevant to comparison (e.g., Cost vs Features, Decentralization vs UX)

### 3.2 Differentiation Matrix

> **What to deliver:** Core differentiation comparison with sustainability and convergence analysis
> **Format:** Comparison table (Primary differentiation, Unique advantage, Main weakness, Defensibility), followed by sustainability and convergence bullets

---

## 4. STRATEGIC RECOMMENDATIONS

> **Purpose:** Actionable recommendations tailored to comparison purpose
> **Questions:** Which project is recommended? | What's the competitive thesis / positioning strategy / category insight? | What are next steps?
> **Detail level:** detailed

### 4.1 Purpose-Specific Recommendations

> **What to deliver:** Recommendations matching stated purpose - choose ONE of: (A) Investment Comparison, (B) Product Positioning, (C) Category Understanding
> **Format:** Structured recommendations with supporting evidence. See objectives.md for purpose-specific format guidance
> **Note:** Only include the subsection matching stated purpose

### 4.2 Risk Assessment Summary

> **What to deliver:** Comparative risk profile across 5 risk types (Technology, Market, Competitive, Execution, Regulatory)
> **Format:** Comparison table with overall risk winner

### 4.3 Next Steps

> **What to deliver:** Immediate actions (0-4 weeks), medium-term actions (1-3 months), follow-up research recommendations, decision readiness
> **Format:** Numbered actions tied to recommendations, checkbox list for follow-up workflows

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise
> **Format:** Per finding - title, context paragraph, source
> **Note:** Optional - use only for insights that don't belong in Sections 1-4

---

## SOURCES & REFERENCES

### Primary Sources
{Project documentation, on-chain data, official announcements}

### Secondary Sources
{Research reports, analytics platforms, industry analyses}

### Tertiary Sources
{News, community discussions}

### Data Providers
{DeFi Llama, Token Terminal, CoinGecko, etc.}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
