# COMPETITIVE ANALYSIS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Competitive Analysis (competitive-analysis)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Establish comprehensive head-to-head comparison of user-selected projects through systematic profiling, benchmarking, and positioning analysis. Delivers detailed project profiles with SWOT and moats assessment, rigorous comparison tables across metrics and capabilities, positioning maps identifying differentiation opportunities, and purpose-specific recommendations with evidence-based rationale. Enables confident investment or positioning decisions through fair, balanced, multi-source validated comparative analysis.

---

## OBJECTIVES

1. **Profile Each Project Comprehensively** - Conduct SWOT analysis, competitive moats assessment across 6 dimensions, 8-criteria crypto-native evaluation, and bear case analysis for each project with equal depth and no favoritism

2. **Create Head-to-Head Benchmarking Tables** - Build comparison tables for metrics benchmarking, feature matrix, technical architecture, and team backing with consistent structure enabling easy comparison and leader identification

3. **Conduct Comparative Positioning Analysis** - Build positioning map showing projects on strategic dimensions, identify positioning clusters and white spaces, create differentiation matrix analyzing unique advantages and weaknesses, and assess positioning effectiveness

4. **Deliver Purpose-Specific Recommendations** - Provide recommendations tailored to comparison purpose: investment ranking with scores, positioning strategy, or comparative insights, with risk assessment and alternatives for all cases

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{research-methodology}`

---

## VALIDATION CRITERIA

- [ ] **Comprehensive & Balanced Profiling:** All projects profiled with equal depth covering SWOT, moats, crypto-native evaluation, and bear case, no favoritism or incomplete profiles, balanced perspective acknowledging both strengths and weaknesses
- [ ] **Rigorous Comparison Quality:** Benchmarking tables use consistent apples-to-apples metrics with same definitions and timeframes, positioning analysis grounded in evidence not subjective preference, all data cross-validated from 2+ sources with freshness verified
- [ ] **Purpose-Aligned Actionability:** Recommendations directly address user's stated comparison purpose (investment/positioning/category understanding), decision framework clear and evidence-based, next steps specific and actionable not vague suggestions

---

## DELIVERABLES

- **Primary output:**
    - Type: `{output_type}` (brief | standard | comprehensive)
    - Format: `{output_format}`
    - Path: `{output_path}`
