# BRAINSTORM

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - WORKFLOW OBJECTIVES**
> **NAME:** Brainstorm Session (brainstorm)
> **PURPOSE:** Define WHAT this workflow must achieve (mission, objectives, validation, deliverables)

---

## MISSION

Facilitate structured exploration of any topic through interactive ideation. Help user discover insights, generate ideas, challenge assumptions, and reach clarity through AI-guided brainstorming techniques. Session continues until user is satisfied, with optional milestone saves to preserve context.

---

## OBJECTIVES

1. **Frame the Problem** - Deeply understand the topic, constraints, prior thinking, and success criteria before exploration begins

2. **Facilitate Exploration** - Guide user through ideation using appropriate techniques (divergent, convergent, deep-dive, or challenge modes)

3. **Generate Insights** - Help user discover new perspectives, challenge assumptions, and connect ideas in novel ways

4. **Preserve Context** - Detect meaningful milestones and offer saves to prevent context loss during extended sessions

5. **Synthesize Discoveries** - Organize accumulated insights into coherent themes with actionable next steps when session ends

---

## METHODOLOGY PRINCIPLES

**RECALL & APPLY GUIDE:** `{brainstorming-guide}`

**Brainstorm-Specific Principles:**
- Questions over statements - lead by asking, not telling
- User drives direction - AI facilitates, doesn't dictate
- Research on-demand - use tools when facts needed, not on schedule
- Technique switching - adapt approach when user is stuck
- No fixed template - output structure emerges from session

---

## VALIDATION CRITERIA

- [ ] User's core question/problem clearly understood before exploration
- [ ] Multiple perspectives explored (not single-track thinking)
- [ ] Assumptions identified and challenged where appropriate
- [ ] User expressed satisfaction with exploration depth
- [ ] Key insights captured (in memory or saved file)

---

## DELIVERABLES

- **Primary output:**
    - Type: `session summary` (optional - only if user requests save)
    - Format: `{output_format}`
    - Path: `{output_path}`

- **Session artifacts (accumulated in memory):**
    - Insights discovered
    - Ideas generated
    - Challenges identified
    - Open questions
    - Suggested next steps

---

*Philosophy: Exploration without fixed destination. The journey IS the output. AI facilitates thinking, user owns the discoveries.*
