<!--
UNIVERSAL WORKFLOW TEMPLATE
INSTRUCTIONS:
- Copy to: {workflow-name}/template.md
- Replace ALL {PLACEHOLDERS} with workflow-specific content
- Recall & Apply: {output-standards} (./framework/guides/output-standards.md)

PLACEHOLDERS:
- {WORKFLOW_OUTPUT_TITLE} = Output document title
- {SECTION_NAME} = Section titles (numbered 1-N)
- {SUBSECTION_NAME} = Subsection titles

LANGUAGE:
- Output: Follow core-config.yaml → language.output
- Terminology: English (crypto domain terms always preserved)

DETAIL LEVEL:
- concise: Synthesis and key findings only
- standard: Balanced presentation with essential details
- detailed: Comprehensive with full details, examples, comparisons

SECTION HEADER FORMAT:
> **Purpose:** {What this section delivers}
> **Questions:** {Question 1? | Question 2?}
> **Detail level:** {concise | standard | detailed}

SUBSECTION HEADER FORMAT:
> **What to deliver:** {Deliverable scope}
> **Format:** {Structure specification}
-->

# {WORKFLOW_OUTPUT_TITLE}

**Topic:** {1 sentence describing research subject}
**Research depth:** {quick|standard|deep}
**Output type:** {brief|standard|comprehensive}

---

## Key Takeaways

> **Purpose:** Executive summary for quick decision-making
> **Detail level:** concise

{WORKFLOW-SPECIFIC TAKEAWAY STRUCTURE}

---

## {N}. {SECTION_NAME}

> **Purpose:** {What this section delivers}
> **Questions:** {Question 1? | Question 2?}
> **Detail level:** {concise | standard | detailed}

### {SUBSECTION_NAME}

> **What to deliver:** {Deliverable scope}
> **Format:** {Structure specification}

{CONTENT}

---

## {N+1}. {OUTLOOK_OR_IMPLICATIONS_TITLE}

> **Purpose:** Synthesize analysis into actionable assessment
> **Questions:** What is the overall assessment? | What are key drivers? | What to monitor?
> **Detail level:** brief

> **What to deliver:**
> - **{Primary Rating}:** {RATING_SCALE} (e.g., BULLISH/NEUTRAL/BEARISH or POSITIVE/NEUTRAL/NEGATIVE)
> - **Confidence:** HIGH / MEDIUM / LOW
> - **Key Drivers:** Top 3-5 factors supporting the rating
> - **Rationale:** Brief evidence-based justification
> - **Catalysts:** Events that could shift the assessment
> - **Monitoring Priorities:** Key metrics/signals to track
> **Format:** Rating with supporting rationale and monitoring framework
> **Note:** This is {domain}-specific view; combine with other analyses for full investment decision

---

## ADDITIONAL RESEARCH FINDINGS

> **Purpose:** Notable discoveries outside previous sections
> **Detail level:** concise

{FINDINGS IF ANY}

---

## SOURCES & REFERENCES

### Primary Sources
{Direct sources: official docs, on-chain data, interviews}

### Secondary Sources
{Interpretive sources: media, research reports, analyses}

### Tertiary Sources
{Community sources: discussions, social media, unverified}

---

**Total:** [N] sources | **Date range:** [Earliest] to [Latest]
