# OUTPUT STANDARDS

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - GUIDE**
> **TYPE:** Standard Guide
> **PURPOSE:** Universal quality standards and validation for all outputs
> **USAGE:** Apply before delivery to validate output quality

---

## PURPOSE

This guide defines universal quality standards that apply to **all outputs** from the CIRF framework, regardless of workflow type.

**Scope:** BEFORE DELIVERY only (not research execution - see research-methodology.md for DURING research)

**What This Guide Provides:**
- **Output Type Configuration** - Understanding the `{output_type}` parameter and how it controls presentation format
- **7 Quality Criteria** - Apply to every deliverable (completeness, accuracy, consistent, goal-aligned, actionable, clarity, concise & clean)

**Core Principle:** Every output must meet all 7 universal quality criteria. Each output type emphasizes different criteria based on its purpose, but all 7 are evaluated for every deliverable.

---

## OUTPUT TYPE CONFIGURATION

The `{output_type}` parameter determines how to present research findings.

### What Output Type Controls

Output type determines **presentation format and depth** - modulating length, structure, detail level, and evidence inclusion.

### The Three Output Types

#### Brief (`output_type: brief`)

- **Characteristics**: Executive summary style, key insights only
- **Length**: ~1,000-2,000 words
- **Use when**: Quick overview needed, time-sensitive decisions

#### Standard (`output_type: standard`) - Recommended

- **Characteristics**: Balanced report, essential evidence included
- **Length**: ~3,000-5,000 words
- **Use when**: Most deliverables, balanced depth and brevity

#### Comprehensive (`output_type: comprehensive`)

- **Characteristics**: Detailed report, full evidence and analysis
- **Length**: ~7,000-10,000 words
- **Use when**: Critical decisions, complete documentation needed

**Note**: Minor variance (±30%) acceptable for complex topics. Exceeding target significantly requires explicit justification in output.

---

## 7 UNIVERSAL QUALITY CRITERIA

These criteria apply to **all outputs** from CIRF framework.

### Criterion 1: COMPLETENESS

**Definition:** Contains all necessary information for autonomous execution

**Application:**
- All required elements present
- No external dependencies assumed without documentation
- Self-contained for intended scope

**Example:**
- ❌ "Follow the standard process" (what standard?)
- ✅ "Follow these 4 steps: [1] [2] [3] [4]" (complete)

---

### Criterion 2: ACCURACY

**Definition:** Factually correct, logically sound, technically precise

**Application:**
- No factual errors
- No logical contradictions
- No misleading statements
- Terminology used correctly

---

### Criterion 3: CONSISTENT

**Definition:** Uniform style, terminology, structure across all outputs

**Application:**
- Same terms for same concepts
- Same structure for same output types
- Same formatting conventions
- No contradictions between outputs

---

### Criterion 4: GOAL-ALIGNED

**Definition:** Serves intended purpose, no scope creep, right abstraction level

**Application:**
- Each output serves its specific purpose
- Stay within defined scope
- Right level of abstraction for intended audience
- No mixing purposes or scope creep

**Example:**
- ❌ High-level overview including detailed implementation specifications (scope creep)
- ✅ High-level overview with strategic implications that inform implementation decisions (goal-aligned)

---

### Criterion 5: ACTIONABLE

**Definition:** Enables immediate execution, concrete steps, clear outcomes

**Application:**
- Action verbs (Verify, Calculate, Analyze)
- Concrete steps (not just concepts)
- Clear success criteria
- Measurable outcomes

**Example:**
- ❌ "Think about the problem" (not actionable)
- ✅ "Analyze X using methodology Y with data from Z" (actionable)

---

### Criterion 6: CLARITY

**Definition:** Easy to understand, unambiguous, well-organized

**Application:**
- Clear structure with logical flow
- Unambiguous language (no vague terms)
- One interpretation only
- Headers guide navigation

**Example:**
- ❌ "Do thorough research" (vague)
- ✅ "Verify claims from multiple independent sources" (clear)

---

### Criterion 7: CONCISE & CLEAN

**Definition:** Brief while maintaining completeness, minimal complexity, no unnecessary elements

**Application:**
- Each concept stated once (no redundancy, no repetition)
- Short sentences, no filler words
- Simplest solution that works
- No over-engineering
- Clean formatting, no clutter
- Bullet points over paragraphs (when appropriate)
- Active voice preferred

**Example:**
- ❌ "In the event that you encounter a situation where..." (verbose)
- ✅ "When you encounter..." (concise)

---

**End of Output Standards Guide**
