# CONTENT STYLE

> **CIRF - CRYPTO INTERACTIVE RESEARCH FRAMEWORK - GUIDE**
> **TYPE:** Customizable Style Guide
> **PURPOSE:** Define writing style standards for content outputs
> **USAGE:** Defaults are institutional-grade crypto research style. Customize as needed.

---

<!--
============================================================================
HOW TO USE THIS TEMPLATE
============================================================================
1. Defaults reflect institutional-grade crypto research standards
2. Modify any section to match your preferences
3. Delete sections you don't need
4. Add new sections as needed

Agents will reference this guide when creating content.
============================================================================
-->

## BRAND VOICE

<!-- Define how your content should "sound" to readers -->

**Voice description:**
Professional, analytical, and objective. Research-first approach with data-driven insights. Authoritative yet accessible to sophisticated investors.

**Tone attributes:**
- Analytical - Lead with data and evidence
- Objective - Present balanced perspectives
- Precise - Use accurate terminology
- Substantive - Depth over surface-level takes
- Measured - Avoid hype and sensationalism

---

## TARGET AUDIENCE

<!-- Define who you're writing for -->

**Primary audience:**
Institutional investors, fund managers, and sophisticated crypto-native participants seeking actionable research.

**Audience knowledge level:**
Advanced - Familiar with crypto fundamentals, DeFi mechanics, on-chain analysis, and market dynamics. Expects professional-grade analysis without basic explanations.

---

## CONTENT STRUCTURE

<!-- Define how content should be organized -->

**Preferred formats:**
- [x] Research reports
- [x] Investment memos
- [x] Market analysis
- [x] Due diligence documents

**Structure preferences:**
- Executive summary upfront with key findings
- Thesis statement clearly articulated
- Evidence-based argumentation
- Risk assessment included
- Actionable conclusions

---

## WRITING GUIDELINES

<!-- Define specific writing rules -->

**Do:**
- Lead with the conclusion, then support with evidence
- Quantify claims with specific data points
- Cite sources for all external data
- Acknowledge uncertainty and limitations
- Include bull/bear case perspectives
- Use precise language and avoid ambiguity

**Don't:**
- Make price predictions or financial advice
- Use promotional or hype language
- Present speculation as fact
- Omit material risks or counterarguments
- Use vague qualifiers ("many", "significant", "soon")
- Include unverified information

---

## QUALITY STANDARDS

<!-- Define your quality checklist -->

- [ ] Thesis is clearly stated
- [ ] All claims supported by cited data
- [ ] Multiple sources cross-referenced
- [ ] Risks and counterarguments addressed
- [ ] Time-sensitive data dated
- [ ] No promotional language
- [ ] Conclusions are actionable
- [ ] Formatted for professional presentation

---

<!--
============================================================================
CUSTOMIZATION NOTES
============================================================================
- This file is referenced by the create-content workflow
- Defaults reflect institutional research standards
- Modify to match your organization's style guide
============================================================================
-->
