/**
 * Circle Wallet Skill - Main Export
 * Reusable USDC wallet functionality for OpenClaw agents
 */

export { CircleWallet } from './wallet';
export type { WalletConfig } from './wallet';
export { loadConfig, saveConfig, configExists, ensureConfigDir } from './config';
export { generateEntitySecret, registerEntitySecret } from './entity';
export { isValidEthereumAddress, resolveWalletId, validateUSDCAmount, formatUSDCBalance } from './utils';
export { SUPPORTED_CHAINS, getChainInfo, getMainnetChains, getTestnetChains, isValidChain, getUSDCTokenId } from './chains';
export type { ChainInfo } from './chains';
