# IT Strategy Frameworks

## Strategy Document Template

```markdown
# IT Strategy 20XX-20XX

## Vision
Where technology takes the business in 3-5 years.

## Current State Assessment
- Infrastructure: [cloud/hybrid/on-prem]
- Technical debt: [low/medium/high]
- Team capability: [gaps identified]
- Vendor landscape: [key dependencies]

## Strategic Pillars
1. [Pillar 1] — e.g., Cloud-first migration
2. [Pillar 2] — e.g., Data platform modernization
3. [Pillar 3] — e.g., Developer experience

## Initiatives by Pillar
| Pillar | Initiative | Timeline | Investment |
|--------|-----------|----------|------------|
| | | | |

## Success Metrics
- [Metric 1]: Current → Target
- [Metric 2]: Current → Target

## Risks and Mitigations
| Risk | Impact | Mitigation |
|------|--------|------------|
| | | |

## Governance
- Review cadence: [quarterly]
- Decision forum: [IT steering committee]
```

## Build vs Buy Framework

### Default to Buy When:
- Commodity capability (email, HR systems, CRM)
- Time-to-market is critical
- Maintenance burden is high
- Vendor ecosystem is mature

### Default to Build When:
- Core competitive advantage
- Unique business logic
- Integration requirements are extreme
- Vendor options don't fit

### Evaluation Criteria
| Factor | Weight | Build Score | Buy Score |
|--------|--------|-------------|-----------|
| Time to value | | | |
| Total cost (5yr) | | | |
| Customization need | | | |
| Maintenance burden | | | |
| Strategic fit | | | |

## Technology Radar

Track technology adoption status:

| Ring | Meaning |
|------|---------|
| **Adopt** | Ready for production, recommended |
| **Trial** | Worth pursuing, proof of concept stage |
| **Assess** | Exploring, not yet committed |
| **Hold** | Do not start new projects with this |

Categories:
- Languages & Frameworks
- Infrastructure & Platforms
- Tools
- Techniques

## Annual Planning Cycle

| Month | Activity |
|-------|----------|
| Q4 | Strategy review, next year planning |
| Q1 | Budget finalization, initiative kickoff |
| Q2 | Mid-year progress review |
| Q3 | Strategic adjustments, pre-planning |
