---
name: chrome-devtools-mcp
description: "Chrome DevTools MCP — Google's official browser automation and testing server. Control Chrome via Puppeteer through MCP protocol: click, fill forms, navigate, screenshot, performance traces, network inspection, console debugging. Use for browser testing, web automation, performance analysis, UI testing, form filling, and visual regression."
homepage: https://github.com/ChromeDevTools/chrome-devtools-mcp
license: Apache-2.0
compatibility: Node.js v20.19+, Chrome/Chromium
metadata: {"openclaw": {"emoji": "🌐", "requires": {"env": []}, "homepage": "https://github.com/ChromeDevTools/chrome-devtools-mcp"}}
---

# 🌐 Chrome DevTools MCP

Google's official Chrome DevTools MCP server — gives AI agents full control of a live Chrome browser via Puppeteer and the Chrome DevTools Protocol.

## Features

- **Input automation** — click, drag, fill forms, hover, press keys, upload files, handle dialogs
- **Navigation** — open/close/switch pages, wait for elements/network idle
- **Screenshots & snapshots** — capture page state visually and as DOM
- **Performance traces** — record and analyze Chrome performance traces with insights
- **Network inspection** — list/inspect network requests and responses
- **Console debugging** — read console messages with source-mapped stack traces
- **Device emulation** — emulate mobile devices, resize viewport
- **Form automation** — fill multiple form fields at once

## Requirements

- Node.js v20.19+ (already available in OpenClaw)
- Chrome/Chromium browser

## Quick Start

### Install & verify

```bash
npx -y chrome-devtools-mcp@latest --help
```

### Start the MCP server

```bash
# Standard (launches Chrome automatically)
npx -y chrome-devtools-mcp@latest

# Headless mode (for servers)
npx -y chrome-devtools-mcp@latest --headless

# Connect to existing Chrome (must be started with --remote-debugging-port=9222)
npx -y chrome-devtools-mcp@latest --browser-url=http://127.0.0.1:9222

# Disable telemetry
npx -y chrome-devtools-mcp@latest --no-usage-statistics --no-performance-crux
```

### OpenClaw MCP Integration

Add to your `openclaw.json` under MCP servers:

```json
{
  "mcp": {
    "servers": {
      "chrome-devtools": {
        "command": "npx",
        "args": ["-y", "chrome-devtools-mcp@latest", "--headless", "--no-usage-statistics"]
      }
    }
  }
}
```

Or use the setup script:

```bash
python3 {baseDir}/scripts/setup_chrome_mcp.py setup
python3 {baseDir}/scripts/setup_chrome_mcp.py status
python3 {baseDir}/scripts/setup_chrome_mcp.py test
```

## Tool Reference

### Input Automation (8 tools)

| Tool | Description | Key Params |
|------|-------------|------------|
| `click` | Click an element | `uid` (required), `dblClick` |
| `drag` | Drag element onto another | `from_uid`, `to_uid` |
| `fill` | Type text into input/textarea/select | `uid`, `value` |
| `fill_form` | Fill multiple form elements at once | `elements[]` |
| `handle_dialog` | Accept/dismiss browser dialogs | `action` (accept/dismiss) |
| `hover` | Hover over element | `uid` |
| `press_key` | Press keyboard key | `key` |
| `upload_file` | Upload file to input | `uid`, `paths[]` |

### Navigation (6 tools)

| Tool | Description | Key Params |
|------|-------------|------------|
| `navigate_page` | Go to URL | `url` |
| `new_page` | Open new tab | `url` |
| `close_page` | Close current tab | — |
| `list_pages` | List all open tabs | — |
| `select_page` | Switch to tab | `index` |
| `wait_for` | Wait for element/network | `event`, `uid`, `timeout` |

### Debugging (5 tools)

| Tool | Description |
|------|-------------|
| `take_screenshot` | Capture page as image |
| `take_snapshot` | Get DOM/accessibility snapshot |
| `evaluate_script` | Run JavaScript in page |
| `list_console_messages` | Get console log entries |
| `get_console_message` | Get specific console message |

### Performance (3 tools)

| Tool | Description |
|------|-------------|
| `performance_start_trace` | Begin performance recording |
| `performance_stop_trace` | Stop and get trace data |
| `performance_analyze_insight` | AI analysis of trace |

### Network (2 tools)

| Tool | Description |
|------|-------------|
| `list_network_requests` | List all network requests |
| `get_network_request` | Get request/response details |

### Emulation (2 tools)

| Tool | Description |
|------|-------------|
| `emulate` | Emulate device (mobile, tablet) |
| `resize_page` | Change viewport size |

## Common Workflows

### Test a webpage
1. `navigate_page` → URL
2. `take_snapshot` → get element UIDs
3. `click`/`fill` → interact with elements
4. `take_screenshot` → capture result

### Performance audit
1. `navigate_page` → URL
2. `performance_start_trace`
3. Interact with page
4. `performance_stop_trace`
5. `performance_analyze_insight`

### Form testing
1. `navigate_page` → form URL
2. `take_snapshot` → identify form fields
3. `fill_form` → fill all fields at once
4. `click` → submit button
5. `take_screenshot` → verify result

## Privacy Notes

- Google collects usage statistics by default — disable with `--no-usage-statistics`
- Performance tools may send trace URLs to Google CrUX API — disable with `--no-performance-crux`
- Avoid sharing sensitive data in browser sessions
