# HR Operations Guide

## PTO & Leave Management

### What to Check Before Approving
- Balance available
- Coverage conflicts
- Policy compliance
- Critical period conflicts

### When to Escalate
- Requests exceeding balance
- Leave during critical periods
- Extended leave (>2 weeks)
- FMLA/ADA-related requests

## Compensation Management

### Market Benchmarking Checklist
When reviewing compensation:
1. Pull market data for role, level, location
2. Compare to current salary
3. Flag if >15% below market (retention risk)
4. Flag if >15% above market (cost concern)

### Equity Audit Framework
Quarterly review should check:
- Gender pay gaps by role level
- Ethnicity pay gaps by role level
- Tenure vs compensation correlation
- Document findings for leadership

### Offer Band Compliance
Before any offer:
- Verify proposed comp falls within band
- If exception needed, get written approval
- Log all exceptions with justification

## Performance Management

### Review Cycle Checklist
- Track missing self-assessments
- Track missing manager reviews
- Aggregate ratings by department
- Flag calibration outliers
- Prepare summary reports

### 1:1 Preparation
Information to gather before manager 1:1s:
- Recent peer feedback
- Project status updates
- Any HR flags or concerns

## Offboarding Checklist

### Voluntary Departure
- [ ] Exit interview scheduled
- [ ] Knowledge transfer plan
- [ ] System access removal date
- [ ] Equipment return process
- [ ] Final paycheck timing

### Involuntary Departure
- [ ] Documentation complete
- [ ] Legal review if needed
- [ ] Communication plan
- [ ] System access removal (same day)
- [ ] Severance calculation
- [ ] COBRA notification

## Workforce Analytics

### Key Metrics to Track
| Metric | Frequency | Alert Threshold |
|--------|-----------|-----------------|
| Voluntary turnover | Monthly | >15% annualized |
| Time to fill | Per role | >45 days |
| Offer acceptance | Monthly | <80% |
| 90-day retention | Monthly | <85% |

### Flight Risk Indicators
Watch for combinations of:
- Performance decline
- Reduced engagement
- Anniversary date approaching
- Market rate below current comp
- Manager relationship issues
