# Hiring & Onboarding Guide

## Job Description Best Practices

### Required Elements
- Role title and level
- Department and reporting structure
- Key responsibilities (5-7 bullets)
- Must-have skills vs nice-to-have
- Location/remote policy
- Comp band (if approved to share)

### Prohibited Phrases (Legal Risk)
- "young and energetic" → age discrimination
- "native English speaker" → national origin
- "digital native" → age proxy
- "able-bodied" → disability
- "culture fit" → can mask bias

### Inclusive Language Tips
- Use gender-neutral pronouns
- Focus on skills, not years of experience
- Avoid unnecessary degree requirements
- List essential functions for ADA compliance

## Screening Checklist

### Must-Have Verification
- [ ] Meets minimum qualifications
- [ ] Legal work authorization
- [ ] Salary expectations aligned
- [ ] Location/remote compatible

### Red Flags to Note
- Unexplained employment gaps (ask, don't assume)
- Frequent short tenures (understand context)
- Mismatched expectations
- Reference concerns

### Interview Best Practices
- Structured questions (same for all candidates)
- Multiple interviewers to reduce bias
- Score against defined criteria
- Document feedback immediately

## Offer Process

### Pre-Offer Checklist
- [ ] Comp within approved band
- [ ] Headcount approved
- [ ] Start date feasible
- [ ] Background check requirements clear

### Offer Letter Must Include
- Position title and department
- Base salary
- Equity grant (if applicable)
- Start date
- At-will statement (where applicable)
- Contingencies (background check, etc.)

### Never Do
- ❌ Verbal offers without written follow-up
- ❌ Promises outside written offer
- ❌ Send offer without final approval
- ❌ Discuss other candidates' offers

## Onboarding Checklist

### Day -7 (Before Start)
- [ ] Welcome email with logistics
- [ ] Equipment ordered
- [ ] System accounts requested
- [ ] Buddy assigned
- [ ] First week schedule drafted

### Day 1
- [ ] Workspace ready
- [ ] Accounts active
- [ ] Welcome meeting scheduled
- [ ] Paperwork completed (I-9, etc.)

### Week 1
- [ ] Team introductions
- [ ] Role expectations review
- [ ] 30/60/90 day goals set
- [ ] Key stakeholder meetings

### Day 30/60/90 Check-ins
- [ ] Progress against goals
- [ ] Integration concerns
- [ ] Training needs
- [ ] Feedback collected
