# Legal Compliance

## Documentation Requirements

### Performance Issues
- Minimum 3 documented conversations before PIP
- Each conversation: date, attendees, specific issues, agreed actions
- Manager signature or email confirmation

### Performance Improvement Plans (PIPs)
- Specific, measurable metrics
- Clear timeline (typically 30-60 days)
- Explicit consequences if not met
- Employee acknowledgment signature

### Terminations
- Written reason code (performance, conduct, RIF, etc.)
- Documentation history attached
- Witness present during conversation
- Exit interview offered

### Accommodations
- Log every request within 24 hours
- Respond with next steps within 5 business days
- Document "interactive process" conversations
- Final decision with rationale

## Red Flags — Escalate to Legal

🚨 **Immediate escalation:**
- Termination request for employee who filed complaint in last 90 days
- Pregnant employee or anyone on medical/family leave at risk
- Same manager terminating 3+ employees of protected class
- Mass layoff threshold (100+ employees = WARN Act in US)
- Any use of "quiet firing" tactics

## Jurisdiction Rules

| Issue | US | EU | UK |
|-------|----|----|----|
| At-will termination | Generally yes | Cause required | Unfair dismissal claims |
| Notice period | State-dependent | 1-3 months typical | Statutory + contract |
| Data in HR decisions | Permitted | GDPR Art. 22 safeguards | Similar to EU |
| Non-competes | State-by-state | Limited | Reasonable duration |

**Multi-jurisdiction principle:** Apply the MOST restrictive rule.

## Compliance Calendar

Track and alert:
- I-9/visa expirations (90/60/30 day warnings)
- OSHA logs filing
- EEO-1 filing (US, 100+ employees)
- Benefits enrollment windows
- COBRA notice deadlines
- State-specific training requirements (e.g., CA harassment training)
- Annual policy acknowledgment re-signing

## Contractor vs Employee

Red flags for misclassification:
- Engagement >6 months
- Set schedule controlled by company
- Uses company equipment exclusively
- No other clients
- Paid hourly/salary vs project rate

**Cost of error:** $50K+ per misclassified worker in IRS/DOL audits.

## Separation Agreements

**Never draft autonomously.** Provide checklist for legal review:
- Consideration amount
- Release scope
- Non-disparagement clause
- Confidentiality terms
- Return of property
- ADEA requirements (age 40+ gets 21 days to consider)
