---
name: Chinese
description: Write Chinese that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Chinese is technically correct but sounds off. Too formal. Too 书面语 (written style). Natives write more casually, with particles, expressions, and internet slang. Match that.

## Formality Default

Default register is too high. Casual Chinese is the norm in daily communication. Unless explicitly formal: lean casual. 口语 over 书面语.

## 你 vs 您

Get this right:
- 您: elderly, superiors, customer service, very formal
- 你: everyone else, peers, friends, casual
- Overusing 您 = robotic, overly polite
- In casual contexts, 你 is always correct

## Sentence-Final Particles

These are essential for natural Chinese:
- 啊/呀: softening, friendliness
- 呢: follow-up questions, "what about..."
- 吧: suggestions, mild uncertainty
- 嘛: obviousness, "of course"
- 哦/噢: acknowledgment, realization
- 啦: completed action + softening
- Missing these = textbook Chinese

## Fillers & Flow

Real Chinese has fillers:
- 那个, 就是, 然后
- 嗯, 额, 这个
- 反正, 其实, 不过
- 对了, 话说, 说真的

## Casual Contractions

Spoken patterns in writing:
- 不知道 → 不知
- 这样子 → 这样
- 什么 → 啥 (very casual)
- 没有 → 没
- 为什么 → 干嘛 (casual)

## Expressiveness

Don't pick the safe word:
- 好 → 太好了, 超棒, 绝了
- 不好 → 太差了, 烂, 坑
- 很多 → 超多, 一堆
- 非常 → 超, 巨, 特别

## Internet Slang

Modern Chinese uses these:
- 666: impressive, skilled
- 哈哈哈/233: laughing
- 牛: awesome, impressive
- 绝了: peak, perfect
- 真的假的: really?/no way
- yyds (永远的神): GOAT
- Use appropriately for context/age

## Common Expressions

Natural expressions:
- 没问题, 好的好的, 行行行
- 随便, 无所谓, 都行
- 厉害, 可以啊, 不错不错
- 算了, 别说了, 得了

## Reactions

React naturally:
- 哇, 天哪, 我去, 卧槽 (crude)
- 真的吗, 不会吧, 啊?
- 厉害了, 服了, 绝
- 笑死, 无语, 醉了

## Character Set Consistency

Never mix:
- Mainland: Simplified (简体)
- Taiwan: Traditional (繁體)
- If unclear, ask. Stay consistent throughout.

## Regional Awareness

If region known, adapt:
- Mainland: 视频, 软件, 网络
- Taiwan: 影片, 軟體, 網路
- Different expressions, same meaning
- Don't mix regions.

## Punctuation

Chinese punctuation:
- 。not . for periods
- ，not , for commas
- 「」or "" for quotes
- ！？for emphasis
- 、for listing

## The "Native Test"

Before sending: would a Chinese speaker screenshot this as "AI-generated"? If yes—too formal, too stiff, missing particles. Add 口语 flavor.
