# ClawHub技能市场页面模板

## 🎯 技能页面设计规范

### 1. 页面结构标准
```
# [技能名称] - [简短描述]

## 🎯 概述
[2-3句话描述技能的核心价值和功能]

## 📊 技能信息
- **版本**: [版本号]
- **开发者**: [开发者名称]
- **评分**: [评分星级]
- **下载量**: [下载数量]
- **最后更新**: [更新时间]
- **许可证**: [许可证类型]
- **仓库**: [GitHub仓库链接]
- **兼容性**: [兼容的OpenClaw版本]

## 🚀 快速开始
```bash
# 安装命令
npx clawhub install [技能名称]

# 或使用GitHub
[GitHub安装说明]
```

## ✨ 核心功能
### [功能分类1]
- [功能点1]
- [功能点2]
- [功能点3]

### [功能分类2]
- [功能点1]
- [功能点2]
- [功能点3]

## 🔧 使用示例
```[语言]
[代码示例]
```

## ⚙️ 配置说明
```[配置格式]
[配置示例]
```

## 📚 文档链接
- [完整文档](链接)
- [API参考](链接)
- [使用教程](链接)
- [更新日志](链接)

## 👥 社区支持
- [GitHub Issues](链接)
- [Discord频道](链接)
- [论坛](链接)
- [邮件列表](链接)

## ⭐ 用户评价
> "[用户评价内容]" - [用户名称]
```

## 🎨 视觉设计指南

### 颜色方案
```css
/* 主色调 */
--primary-color: #3B82F6; /* 科技蓝 */
--secondary-color: #F97316; /* 活力橙 */
--success-color: #10B981; /* 成功绿 */
--warning-color: #F59E0B; /* 警告黄 */
--danger-color: #EF4444; /* 危险红 */

/* 中性色 */
--bg-color: #F9FAFB; /* 背景灰 */
--text-color: #1F2937; /* 文字深灰 */
--border-color: #E5E7EB; /* 边框浅灰 */
```

### 图标使用规范
```
🎯 概述部分: 使用目标图标
📊 信息部分: 使用图表图标
🚀 快速开始: 使用火箭图标
✨ 核心功能: 使用星星图标
🔧 使用示例: 使用工具图标
⚙️ 配置说明: 使用齿轮图标
📚 文档链接: 使用书籍图标
👥 社区支持: 使用人群图标
⭐ 用户评价: 使用星星图标
```

### 排版规范
```
标题层级:
# H1 - 页面主标题 (技能名称)
## H2 - 主要部分标题
### H3 - 子部分标题
#### H4 - 小标题

字体大小:
- 主标题: 2rem (32px)
- 部分标题: 1.5rem (24px)
- 正文: 1rem (16px)
- 小字: 0.875rem (14px)

行高:
- 标题: 1.2
- 正文: 1.5
- 代码: 1.4
```

## 📝 内容编写指南

### 概述部分编写要点
```
1. 价值主张: 明确说明技能的核心价值
2. 目标用户: 说明适合哪些用户使用
3. 主要功能: 简要列出主要功能
4. 技术特点: 说明技术优势和特点

示例:
"中文工具包让OpenClaw真正理解中文！提供全面的中文文本处理、翻译、OCR识别等功能，帮助中文开发者更好地利用OpenClaw的能力。"
```

### 功能描述编写要点
```
1. 功能分类: 按逻辑分类功能
2. 功能点: 每个功能点简洁明了
3. 技术说明: 说明使用的技术或算法
4. 优势说明: 说明功能优势

示例:
### 📖 中文文本处理
- 中文分词 (使用jieba库，准确率>95%)
- 关键词提取 (TF-IDF算法，支持自定义词典)
- 文本摘要 (智能摘要生成，保留核心信息)
- 文本统计 (字符数、词数、语言检测)
```

### 代码示例编写要点
```
1. 完整性: 提供完整的可运行示例
2. 简洁性: 示例代码简洁明了
3. 注释: 添加必要的注释说明
4. 输出: 说明预期输出结果

示例:
```python
from chinese_tools_core import ChineseToolkit

# 初始化工具包
toolkit = ChineseToolkit()

# 中文分词示例
segments = toolkit.segment("今天天气真好")
print(segments)  # 输出: ['今天天气', '真', '好']
```
```

### 配置说明编写要点
```
1. 配置格式: 说明配置文件的格式
2. 必填项: 说明哪些配置是必需的
3. 可选项: 说明哪些配置是可选的
4. 默认值: 说明配置的默认值

示例:
```json
{
  "api_keys": {
    "baidu_translate": {
      "app_id": "your_app_id",  // 必填: 百度翻译API的App ID
      "app_key": "your_app_key" // 必填: 百度翻译API的App Key
    }
  },
  "cache": {
    "enabled": true,  // 可选: 是否启用缓存，默认true
    "ttl": 3600       // 可选: 缓存过期时间(秒)，默认3600
  }
}
```
```

## 🔗 链接管理指南

### 内部链接规范
```
文档链接:
- 使用相对路径: docs/api.md
- 或绝对路径: https://github.com/username/repo/docs/api.md

资源链接:
- 图片: assets/images/example.png
- 配置文件: config.example.json
- 示例代码: examples/basic_usage.py
```

### 外部链接规范
```
GitHub链接:
- 仓库: https://github.com/username/repo
- Issues: https://github.com/username/repo/issues
- Releases: https://github.com/username/repo/releases

社区链接:
- Discord: https://discord.com/invite/clawd
- 论坛: https://forum.clawd.org.cn
- 邮件列表: mailto:skill-name@openclaw.ai
```

## 📊 数据展示规范

### 统计数据显示
```
下载量显示:
- 格式: 1,234+ (超过1000显示千位分隔符)
- 更新频率: 每日更新
- 来源: ClawHub官方统计

评分显示:
- 格式: ⭐⭐⭐⭐⭐ (4.8/5.0)
- 计算方式: 加权平均
- 最少评价数: 10个评价后才显示评分
```

### 兼容性信息
```
版本兼容性:
- OpenClaw: >=2026.2.0
- Python: >=3.8
- 操作系统: Windows 10+, macOS 10.15+, Linux

依赖要求:
- 核心依赖: [依赖列表]
- 可选依赖: [可选依赖列表]
- 系统要求: [系统要求]
```

## 🎯 优化建议

### SEO优化
```
标题优化:
- 包含关键词: "中文工具包 - OpenClaw中文处理专家"
- 长度适中: 50-60字符

描述优化:
- 包含核心功能关键词
- 说明技能价值
- 长度: 150-160字符

关键词优化:
- 主要关键词: 中文工具包, OpenClaw, 中文处理
- 次要关键词: 分词, 翻译, 拼音, 文本处理
- 长尾关键词: OpenClaw中文分词工具
```

### 用户体验优化
```
页面加载优化:
- 图片压缩
- 代码高亮异步加载
- 懒加载长内容

移动端优化:
- 响应式设计
- 触摸友好
- 字体大小适配

无障碍访问:
- 语义化HTML
- 图片alt文本
- 键盘导航支持
```

### 转化率优化
```
安装引导优化:
- 明显的安装按钮
- 一键复制安装命令
- 多种安装方式说明

信任建立优化:
- 用户评价展示
- 下载量显示
- 开发者信息展示

行动号召优化:
- 明确的下一步指引
- 社区参与引导
- 问题反馈渠道
```

## 🚀 发布检查清单

### 内容检查
- [ ] 标题准确且吸引人
- [ ] 概述清晰明了
- [ ] 功能描述完整
- [ ] 代码示例可运行
- [ ] 配置说明详细
- [ ] 文档链接有效
- [ ] 社区信息完整

### 格式检查
- [ ] Markdown格式正确
- [ ] 图标使用规范
- [ ] 代码块语法正确
- [ ] 链接格式正确
- [ ] 图片alt文本完整
- [ ] 排版美观整洁

### 技术检查
- [ ] 所有链接有效
- [ ] 代码示例无错误
- [ ] 配置示例正确
- [ ] 兼容性信息准确
- [ ] 版本信息正确

### 优化检查
- [ ] SEO优化完成
- [ ] 移动端适配
- [ ] 加载性能优化
- [ ] 无障碍访问支持
- [ ] 转化率优化

## 📈 数据分析指标

### 页面性能指标
```
加载时间:
- 首屏加载: < 2秒
- 完全加载: < 5秒
- 交互时间: < 100ms

用户行为:
- 平均停留时间: > 2分钟
- 滚动深度: > 70%
- 点击率: > 5%
```

### 转化指标
```
安装转化:
- 页面访问到安装: > 10%
- 安装成功率: > 95%
- 用户留存率: > 60%

用户参与:
- 评价提交率: > 5%
- 问题反馈率: > 3%
- 社区参与率: > 2%
```

### 质量指标
```
内容质量:
- 阅读完成率: > 80%
- 代码复制率: > 30%
- 文档查看率: > 40%

用户满意度:
- 平均评分: > 4.0/5.0
- 正面评价率: > 80%
- 问题解决率: > 90%
```

## 🔄 更新维护指南

### 内容更新
```
版本更新:
1. 更新版本号
2. 更新CHANGELOG
3. 更新兼容性信息
4. 更新最后更新时间

功能更新:
1. 添加新功能描述
2. 更新代码示例
3. 更新配置说明
4. 更新文档链接
```

### 问题修复
```
错误修复:
1. 修复拼写错误
2. 修复链接错误
3. 修复代码错误
4. 修复配置错误

内容优化:
1. 优化描述语言
2. 优化示例代码
3. 优化配置说明
4. 优化用户体验
```

### 定期维护
```
月度检查:
1. 检查所有链接
2. 更新统计信息
3. 收集用户反馈
4. 优化页面内容

季度更新:
1. 全面内容审查
2. 技术栈更新
3. 设计风格更新
4. 性能优化更新
```

---
**模板版本**: v1.0
**最后更新**: 2026-02-23
**适用对象**: 技能开发者、市场维护者

**使用此模板创建专业的技能市场页面！** 🚀🎉

**让每个技能都有完美的展示！** ✨📊