---
name: daily-report-generator
description: 职场人日报/周报生成器 - 根据工作记录自动生成结构化日报周报，含问题复盘板块
homepage: https://github.com/Crystaria/openclaw-skills/tree/main/daily-report-generator
---

# 职场人日报/周报生成器

**版本：** 1.0.0  
**作者：** 小爪（基于与老板的实际协作经验）  
**最后更新：** 2026-03-04

---

## 📋 技能说明

这是一个专为职场人设计的日报/周报自动生成工具。

**核心价值：**
- ✅ 节省写日报周报的时间（从 30 分钟→3 分钟）
- ✅ 结构化呈现工作成果
- ✅ 独特的问题复盘板块，助力成长
- ✅ 适用于产品经理、运营、开发等需要频繁汇报的岗位

**差异化特点：**
- 🧩 **独有的"工作问题与解决方案"板块** - 记录技术限制、沟通偏差、错误异常，复盘成长
- 📊 **自动汇总周报** - 基于日报自动生成周报，无需重复劳动
- 💡 **经验总结** - 每个问题都提炼可复用的经验

---

## 🎯 目标用户

- 产品经理
- 运营人员
- 需要频繁汇报的职场人
- 自由职业者
- 远程工作者

---

## 🚀 使用方法

### 方式 1：直接使用（推荐新手）

**步骤：**

1. **发送工作记录**
   ```
   请生成今日日报：
   
   今天完成了：
   - 完成了 XX 项目的需求文档
   - 开了 3 个会
   - 修复了 2 个 bug
   
   待办事项：
   - 明天要和设计对稿
   - 周五前要提交测试
   
   重要信息：
   - 老板下周一出差
   - 项目 deadline 是下周五
   ```

2. **AI 自动生成日报**
   - 结构化整理
   - 补充问题复盘板块
   - 生成 Markdown 格式

3. **复制粘贴到汇报系统**
   - 飞书/钉钉/企业微信
   - 邮件
   - Confluence/Notion

---

### 方式 2：配置自动化（推荐进阶）

**步骤：**

1. **配置定时任务**
   ```bash
   # 每天 22:00 自动生成日报
   # 每周五 17:00 自动生成周报
   ```

2. **配置输出目录**
   ```
   /home/admin/.openclaw/reports/daily/
   /home/admin/.openclaw/reports/weekly/
   ```

3. **配置 MEMORY.md 自动追加**
   - 日报摘要自动追加到长时记忆
   - 方便后续查询和复盘

---

## 📝 输出格式

### 日报格式

```markdown
# 每日工作报告

**日期：** 2026-03-04
**生成时间：** 2026-03-04 22:00

---

## ✅ 完成的工作

1. 完成了 XX 项目的需求文档
2. 开了 3 个会议（产品评审、技术评审、周会）
3. 修复了 2 个线上 bug

---

## ⏳ 待办事项

1. 明天要和设计对稿
2. 周五前要提交测试

---

## 📌 重要信息

1. 老板下周一出差
2. 项目 deadline 是下周五

---

## 🧩 今日工作问题与解决方案

### 问题 1：需求评审时开发提出技术难点

**发现过程：**
在需求评审会议上，后端开发指出某个功能实现成本较高。

**原因分析：**
前期技术方案调研不充分，未与开发充分沟通技术可行性。

**解决过程：**
1. 会后立即与开发一对一沟通
2. 评估替代方案
3. 调整需求优先级，将难点功能放到二期

**经验总结：**
1. 需求评审前应先与核心技术骨干沟通技术可行性
2. 复杂功能应提前做技术方案调研
3. 需求分期是降低风险的有效手段

---

*报告由 AI 助手自动生成*
```

### 周报格式

```markdown
# 每周工作报告

**时间范围：** 2026-02-26 至 2026-03-04
**生成时间：** 2026-03-04 17:00

---

## ✅ 本周完成的工作

1. XX 项目需求文档完成并提交评审
2. 参与 3 次需求评审会议
3. 修复 5 个线上 bug
4. 完成竞品分析报告

---

## ⏳ 跨周期待办事项

1. XX 项目开发中（预计下周三提测）
2. 竞品分析报告待评审
3. 下周一老板出差，需提前准备汇报材料

---

## 📌 本周重要信息

1. 项目 deadline：2026-03-15
2. 团队新增 2 名实习生
3. 下周五全员团建

---

## 🧩 本周工作问题与解决方案

### 问题 1：需求变更频繁导致开发进度延迟

**发现过程：**
周会上开发反馈本周有 3 次需求变更，影响开发节奏。

**原因分析：**
1. 前期需求调研不充分
2. 老板临时想法较多
3. 未建立需求变更流程

**解决过程：**
1. 与老板沟通，建立需求变更审批流程
2. 需求变更需评估影响范围并同步所有相关人员
3. 小变更累积到一定数量后统一发布

**经验总结：**
1. 需求评审前应充分调研，减少后期变更
2. 建立需求变更流程，避免随意变更
3. 变更应及时同步，保持信息透明

---

### 问题 2：会议过多影响工作效率

**发现过程：**
本周日历上有 15 个会议，平均每天 3 个，无法专注工作。

**原因分析：**
1. 部分会议可合并
2. 部分会议无需全员参加
3. 未设置"无会议日"

**解决过程：**
1. 梳理会议清单，合并同类会议
2. 明确参会人员，减少无关人员
3. 设立每周三为"无会议日"

**经验总结：**
1. 定期梳理会议，优化会议结构
2. 设立无会议日，保证专注工作时间
3. 能异步沟通的不开会

---

## 📅 每日详情

| 日期 | 日报链接 |
|------|----------|
| 2026-02-26 | [日报](../daily/日报_2026-02-26.md) |
| 2026-02-27 | [日报](../daily/日报_2026-02-27.md) |
| 2026-02-28 | [日报](../daily/日报_2026-02-28.md) |
| 2026-03-01 | [日报](../daily/日报_2026-03-01.md) |
| 2026-03-02 | [日报](../daily/日报_2026-03-02.md) |
| 2026-03-03 | [日报](../daily/日报_2026-03-03.md) |
| 2026-03-04 | [日报](../daily/日报_2026-03-04.md) |

---

*报告由 AI 助手自动生成*
```

---

## 🔧 技术依赖

**无需外部 API！**

**仅需：**
- ✅ OpenClaw 基础环境
- ✅ 文本处理能力
- ✅ 文件读写权限

**可选配置：**
- ⏳ MEMORY.md（用于长时记忆）
- ⏳ 定时任务（用于自动执行）

---

## ⚠️ 注意事项

### 当前版本限制

1. **半自动化**
   - 日报需要手动提供工作记录
   - 未来可集成任务管理工具（如 Jira、Trello）自动获取

2. **问题复盘需要人工审核**
   - AI 生成的问题复盘可能需要调整
   - 建议人工审核后使用

3. **格式固定**
   - 当前模板较固定
   - 未来可支持自定义模板

---

### 最佳实践

1. **每日记录**
   - 建议每天下班前花 5 分钟记录工作
   - AI 会自动整理成结构化日报

2. **问题复盘**
   - 每个问题都应包含：发现过程、原因分析、解决过程、经验总结
   - 这是个人成长的重要素材

3. **周报汇总**
   - 周报基于日报自动生成
   - 每周五下午检查并微调

4. **长期积累**
   - 日报周报会追加到 MEMORY.md
   - 形成个人工作档案，方便年终总结、晋升答辩

---

## 📚 常见问题

### Q1: 我没有那么多"问题"可以写怎么办？

**A:** 问题不一定是错误，可以是：
- 技术限制（如"某个功能无法自动化"）
- 沟通偏差（如"理解错需求"）
- 流程优化（如"会议太多影响效率"）
- 工具缺失（如"缺少 XX 工具导致效率低"）

**建议：** 每天至少记录 1 个问题，这是快速成长的关键！

---

### Q2: 日报/周报应该多长？

**A:** 
- **日报：** 300-800 字为宜
- **周报：** 800-2000 字为宜
- **问题复盘：** 每个问题 100-300 字

**原则：** 简洁明了，重点突出，避免流水账。

---

### Q3: 如何保护隐私？

**A:** 
- 敏感信息（如薪资、商业机密）不要写入
- 公司内部信息注意脱敏
- 如需公开发布，请删除敏感内容

---

### Q4: 可以自定义模板吗？

**A:** 
- 当前版本模板固定
- 如需自定义，可修改 SKILL.md 中的模板部分
- 未来版本将支持模板配置

---

## 🎓 使用案例

### 案例 1：产品经理的日报

**输入：**
```
今天完成了：
- XX 功能需求文档写完初稿
- 和开发对了一下技术方案
- 用户反馈整理了 20 条

待办：
- 明天需求评审
- 周五前提交最终版

问题：
- 开发说某个功能实现成本高
```

**输出：** 见上方日报格式示例

---

### 案例 2：运营人员的周报

**输入：**
```
本周工作：
- 小红书发了 5 篇笔记
- 涨了 1000 粉
- 和 3 个品牌方沟通了合作

问题：
- 有 2 篇笔记数据不好
- 品牌方说预算有限
```

**输出：** 见上方周报格式示例

---

## 🚀 未来规划

### v1.1（计划中）
- [ ] 支持自定义模板
- [ ] 集成任务管理工具（Jira、Trello、Notion）
- [ ] 支持多平台导出（飞书、钉钉、企业微信）

### v1.2（计划中）
- [ ] 问题复盘智能推荐（基于历史数据）
- [ ] 周报自动汇总优化
- [ ] 支持团队协作（多人日报汇总）

### v2.0（愿景）
- [ ] AI 自动生成改进建议
- [ ] 与绩效考核系统对接
- [ ] 个人成长轨迹可视化

---

## 📞 反馈与支持

**欢迎反馈！**

使用后如有任何问题或建议，欢迎通过以下方式反馈：

- GitHub Issues: https://github.com/Crystaria/openclaw-skills/issues
- 邮件：[待填写]
- 微信：[待填写]

**你的反馈会让这个技能变得更好！** 🙏

---

## 📄 许可证

MIT License

---

*技能创建者：小爪 🦞*  
*基于与老板的实际协作经验打磨而成*  
*2026-03-04*
