# 中文日常生活助手 - 使用示例

## 基本命令示例

### 1. 天气查询
```bash
# 查询北京天气
node scripts/main.js 天气 北京

# 查询上海天气  
node scripts/main.js 天气 上海

# 查询支持的所有城市
node scripts/main.js 天气
```

### 2. 汇率换算
```bash
# 查看所有汇率
node scripts/main.js 汇率

# 100美元兑人民币
node scripts/main.js 汇率 USD CNY 100

# 720人民币兑美元
node scripts/main.js 汇率 CNY USD 720

# 500欧元兑人民币
node scripts/main.js 汇率 EUR CNY 500
```

### 3. 节日查询
```bash
# 查看所有节日
node scripts/main.js 节日

# 查询春节信息
node scripts/main.js 节日 春节

# 查询中秋节信息
node scripts/main.js 节日 中秋节
```

### 4. 生活小贴士
```bash
# 随机小贴士
node scripts/main.js 小贴士

# 健康类小贴士
node scripts/main.js 小贴士 健康

# 饮食类小贴士
node scripts/main.js 小贴士 饮食

# 运动类小贴士
node scripts/main.js 小贴士 运动
```

### 5. 快速翻译
```bash
# 中文译英文
node scripts/main.js 翻译 "你好"
node scripts/main.js 翻译 "谢谢"
node scripts/main.js 翻译 "我爱你"

# 英文译中文
node scripts/main.js 翻译 "Hello"
node scripts/main.js 翻译 "Thank you"
node scripts/main.js 翻译 "Goodbye"
```

## 集成到Clawdbot的示例

### 技能配置示例
```javascript
// 在Clawdbot技能配置中集成
module.exports = {
  name: 'chinese-daily-assistant',
  description: '中文日常生活助手',
  commands: {
    '天气 {city}': async ({ city }) => {
      const { handleWeather } = require('./scripts/main.js');
      return handleWeather(city);
    },
    '汇率 {from} {to} {amount}': async ({ from, to, amount }) => {
      const { handleExchange } = require('./scripts/main.js');
      return handleExchange(`${from} ${to} ${amount}`);
    },
    // ... 其他命令
  }
};
```

### 快速响应示例
```
用户: 今天北京天气怎么样？
助手: 北京天气：
🌡️ 温度：15°C
🌤️ 天气：晴
💧 湿度：45%
🌫️ 空气质量：85 良

用户: 100美元能换多少人民币？
助手: 100 USD (美元) ≈ 720.00 人民币

用户: 春节还有多久？
助手: 春节
📅 日期：2026-02-17
⏳ 倒计时：355天
📖 简介：农历新年，中国最重要的传统节日
```

## 高级使用技巧

### 1. 批量查询
```bash
# 批量查询多个城市天气
for city in 北京 上海 广州; do
  echo "=== $city ==="
  node scripts/main.js 天气 $city
  echo ""
done
```

### 2. 组合使用
```bash
# 天气+小贴士组合
echo "今日天气："
node scripts/main.js 天气 北京
echo ""
echo "今日健康建议："
node scripts/main.js 小贴士 健康
```

### 3. 定时任务
```bash
# 每天早晨获取天气和小贴士（可加入cron）
#!/bin/bash
echo "早安！今天是 $(date '+%Y-%m-%d')"
echo ""
node scripts/main.js 天气 上海
echo ""
node scripts/main.js 小贴士
```

### 4. API调用示例
```javascript
// 在其他Node.js项目中调用
const assistant = require('./scripts/main.js');

// 获取天气
const weather = assistant.handleWeather('北京');
console.log(weather);

// 获取汇率
const exchange = assistant.handleExchange('USD CNY 100');
console.log(exchange);

// 获取随机小贴士
const tip = assistant.handleLifeTip();
console.log(tip);
```

## 故障排除

### 常见问题

1. **命令不工作**
   ```bash
   # 检查Node.js版本
   node --version
   
   # 检查文件权限
   chmod +x scripts/*.js
   ```

2. **城市不支持**
   ```bash
   # 查看支持的城市
   node scripts/main.js 天气
   ```

3. **货币代码错误**
   ```bash
   # 查看支持的货币代码
   node scripts/main.js 汇率
   ```

### 错误信息说明

- `未找到城市"XXX"的天气数据` - 该城市不在支持列表中
- `格式错误` - 命令参数格式不正确
- `未找到翻译` - 该词汇不在翻译词典中

## 扩展建议

### 自定义数据
可以修改以下文件来自定义数据：
- `scripts/main.js` - 修改城市、汇率、节日等数据
- 添加新的翻译词汇
- 扩展小贴士类别

### 集成建议
- 与日历应用集成，自动添加节日提醒
- 与天气预报应用集成，获取实时数据
- 与翻译服务集成，支持更多语言

---

**提示**：本技能设计为模块化，易于扩展和定制。欢迎根据实际需求进行调整！